/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.alice.models.dto.auth;

import com.qaprosoft.alice.models.db.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class JwtUserType
implements UserDetails {
    private static final long serialVersionUID = 2105145272583220476L;
    private long id;
    private String username;
    private String password;
    private List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();

    public JwtUserType(long id, String username, List<Group.Role> roles) {
        this.id = id;
        this.username = username;
        for (Group.Role role : roles) {
            this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role.name()));
        }
        roles.stream().forEach(r -> this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(r.name())));
    }

    public JwtUserType(long id, String username, String password, List<Group.Role> roles) {
        this(id, username, roles);
        this.password = password;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

