/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.alice.client;

import com.qaprosoft.alice.models.dto.RecognitionMetaType;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliceClient.class);
    private static final Integer CONNECT_TIMEOUT = 30000;
    private static final Integer READ_TIMEOUT = 30000;
    private static final String STATUS_PATH = "/api/status";
    private static final String EXECUTION_PATH = "/api/execute/client/";
    private String serviceURL;
    private Client client;
    private String authToken;
    private String command;

    public AliceClient(String serviceURL, String command) {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(JacksonJaxbJsonProvider.class);
        config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        this.serviceURL = serviceURL;
        this.command = command;
        this.client = Client.create((ClientConfig)config);
        this.client.setConnectTimeout(CONNECT_TIMEOUT);
        this.client.setReadTimeout(READ_TIMEOUT);
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isAvailable() {
        boolean isAvailable = false;
        try {
            WebResource webResource = this.client.resource(this.serviceURL + STATUS_PATH);
            ClientResponse clientRS = (ClientResponse)webResource.get(ClientResponse.class);
            if (clientRS.getStatus() == 200) {
                isAvailable = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to send ping", (Throwable)e);
        }
        return isAvailable;
    }

    public synchronized Response<List<RecognitionMetaType>> recognize(File image) {
        Response<Object> response = new Response<Object>(0, null);
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.bodyPart((BodyPart)new FileDataBodyPart("file", image, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        try {
            WebResource webResource = this.client.resource(this.serviceURL + EXECUTION_PATH + this.command);
            ClientResponse clientRS = (ClientResponse)((WebResource.Builder)this.initHeaders(webResource.type(MediaType.MULTIPART_FORM_DATA_TYPE)).accept(new String[]{"application/json"})).post(ClientResponse.class, (Object)multiPart);
            response.setStatus(clientRS.getStatus());
            if (clientRS.getStatus() == 200) {
                response.setObject(clientRS.getEntity((GenericType)new GenericType<List<RecognitionMetaType>>(){}));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to recognize image", (Throwable)e);
        }
        return response;
    }

    public WebResource.Builder initHeaders(WebResource.Builder builder) {
        if (!StringUtils.isEmpty((CharSequence)this.authToken)) {
            builder.header("Authorization", (Object)this.authToken);
        }
        return builder;
    }

    public class Response<T> {
        private int status;
        private T object;

        public Response(int status, T object) {
            this.status = status;
            this.object = object;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }
    }
}

