/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field260
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "260";
    public static final String F_260 = "260";
    @Deprecated
    public static final String PARSER_PATTERN = "<LT><DATE2><HHMM><HHMM>[N]";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "ZEHHN";
    @Deprecated
    public static final String TYPES_PATTERN = "ZEHHN";
    public static final Integer LT_ADDRESS = 1;
    public static final Integer DATE = 2;
    public static final Integer START_TIME = 3;
    public static final Integer END_TIME = 4;
    public static final Integer SESSION_NUMBER = 5;

    public Field260() {
        super(5);
    }

    public Field260(String value) {
        super(value);
    }

    public Field260(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"260")) {
            throw new IllegalArgumentException("cannot create field 260 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field260 newInstance(Field260 source) {
        Field260 cp = new Field260();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("260", value);
    }

    public static Tag emptyTag() {
        return new Tag("260", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        if (value != null) {
            if (value.length() >= 12) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)12));
            }
            if (value.length() >= 18) {
                this.setComponent2(StringUtils.substring((String)value, (int)12, (int)18));
            }
            if (value.length() >= 22) {
                this.setComponent3(StringUtils.substring((String)value, (int)18, (int)22));
            }
            if (value.length() >= 26) {
                this.setComponent4(StringUtils.substring((String)value, (int)22, (int)26));
            }
            if (value.length() > 26) {
                this.setComponent5(StringUtils.substring((String)value, (int)26));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        this.append(result, 4);
        this.append(result, 5);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 260");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 4) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "ZEHHN";
    }

    @Override
    public String typesPattern() {
        return "ZEHHN";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "<LT><DATE2><HHMM><HHMM>[4!n]";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("LT Address");
        result.add("Date");
        result.add("Start Time");
        result.add("End Time");
        result.add("Session Number");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "lTAddress");
        result.put(2, "date");
        result.put(3, "startTime");
        result.put(4, "endTime");
        result.put(5, "sessionNumber");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("ltaddress", 1);
        this.labelMap.put("date", 2);
        this.labelMap.put("starttime", 3);
        this.labelMap.put("endtime", 4);
        this.labelMap.put("sessionnumber", 5);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public LogicalTerminalAddress getComponent1AsLogicalTerminalAddress() {
        return SwiftFormatUtils.getLTAddress(this.getComponent(1));
    }

    public String getLTAddress() {
        return this.getComponent1();
    }

    public LogicalTerminalAddress getLTAddressAsLogicalTerminalAddress() {
        return this.getComponent1AsLogicalTerminalAddress();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent2();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getStartTime() {
        return this.getComponent3();
    }

    public Calendar getStartTimeAsCalendar() {
        return this.getComponent3AsCalendar();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public String getEndTime() {
        return this.getComponent4();
    }

    public Calendar getEndTimeAsCalendar() {
        return this.getComponent4AsCalendar();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Long getComponent5AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(5));
    }

    @Deprecated
    public Number getComponent5AsNumber() {
        Long l = this.getComponent5AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getSessionNumber() {
        return this.getComponent5();
    }

    public Long getSessionNumberAsLong() {
        return this.getComponent5AsLong();
    }

    @Deprecated
    public Number getSessionNumberAsNumber() {
        return this.getComponent5AsNumber();
    }

    public Field260 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field260 setComponent1(LogicalTerminalAddress component1) {
        this.setComponent(1, SwiftFormatUtils.getLTAddress(component1));
        return this;
    }

    public Field260 setLTAddress(String component1) {
        return this.setComponent1(component1);
    }

    public Field260 setLTAddress(LogicalTerminalAddress component1) {
        return this.setComponent1(component1);
    }

    public Field260 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field260 setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field260 setDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field260 setDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field260 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field260 setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    public Field260 setStartTime(String component3) {
        return this.setComponent3(component3);
    }

    public Field260 setStartTime(Calendar component3) {
        return this.setComponent3(component3);
    }

    public Field260 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field260 setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getTime3(component4));
        return this;
    }

    public Field260 setEndTime(String component4) {
        return this.setComponent4(component4);
    }

    public Field260 setEndTime(Calendar component4) {
        return this.setComponent4(component4);
    }

    public Field260 setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field260 setComponent5(Long component5) {
        this.setComponent(5, SwiftFormatUtils.getLong(component5));
        return this;
    }

    public Field260 setComponent5(Number component5) {
        if (component5 instanceof Long) {
            this.setComponent(5, SwiftFormatUtils.getLong((Long)component5));
        } else if (component5 instanceof BigInteger || component5 instanceof Integer) {
            this.setComponent(5, SwiftFormatUtils.getLong(component5.longValue()));
        } else if (component5 != null) {
            this.setComponent(5, SwiftFormatUtils.getLong(component5.longValue()));
        } else {
            this.setComponent(5, null);
        }
        return this;
    }

    public Field260 setSessionNumber(String component5) {
        return this.setComponent5(component5);
    }

    public Field260 setSessionNumber(Long component5) {
        return this.setComponent5(component5);
    }

    public Field260 setSessionNumber(Number component5) {
        return this.setComponent5(component5);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "260";
    }

    public static Field260 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("260");
        if (t == null) {
            return null;
        }
        return new Field260(t);
    }

    public static Field260 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field260.get(msg.getBlock4());
    }

    public static List<Field260> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field260.getAll(msg.getBlock4());
    }

    public static List<Field260> getAll(SwiftTagListBlock block) {
        ArrayList<Field260> result = new ArrayList<Field260>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("260");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field260(f));
            }
        }
        return result;
    }

    public static Field260 fromJson(String json) {
        Field260 field = new Field260();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("lTAddress") != null) {
            field.setComponent1(jsonObject.get("lTAddress").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("startTime") != null) {
            field.setComponent3(jsonObject.get("startTime").getAsString());
        }
        if (jsonObject.get("endTime") != null) {
            field.setComponent4(jsonObject.get("endTime").getAsString());
        }
        if (jsonObject.get("sessionNumber") != null) {
            field.setComponent5(jsonObject.get("sessionNumber").getAsString());
        }
        return field;
    }
}

