/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.MessageMetadataStrategy;
import com.prowidesoftware.swift.model.Money;
import com.prowidesoftware.swift.model.MtId;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.model.mt.DefaultMtMetadataStrategy;
import com.prowidesoftware.swift.model.mt.MTVariant;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

@Entity(name="mt")
@DiscriminatorValue(value="mt")
public class MtSwiftMessage
extends AbstractSwiftMessage {
    private static final transient Logger log = Logger.getLogger(MtSwiftMessage.class.getName());
    private static final long serialVersionUID = -5972656648349958815L;
    @Column(length=35)
    private String pde;
    @Column(length=35)
    private String pdm;
    @Column(length=28, name="mir")
    private String mir;
    @Column(length=16, name="mur")
    private String mur;
    @Column(length=31, name="uuid")
    private String uuid;

    public MtSwiftMessage() {
    }

    public MtSwiftMessage(String fin) {
        this(fin, (MessageMetadataStrategy)new DefaultMtMetadataStrategy());
    }

    public MtSwiftMessage(String fin, MessageMetadataStrategy metadataStrategy) {
        super(fin, FileFormat.FIN, metadataStrategy);
    }

    public MtSwiftMessage(InputStream stream) throws IOException {
        this(stream, (MessageMetadataStrategy)new DefaultMtMetadataStrategy());
    }

    public MtSwiftMessage(InputStream stream, MessageMetadataStrategy metadataStrategy) throws IOException {
        super(stream, FileFormat.FIN, metadataStrategy);
    }

    public MtSwiftMessage(File file) throws IOException {
        this(file, (MessageMetadataStrategy)new DefaultMtMetadataStrategy());
    }

    public MtSwiftMessage(File file, MessageMetadataStrategy metadataStrategy) throws IOException {
        super(file, FileFormat.FIN, metadataStrategy);
    }

    public MtSwiftMessage(AbstractMT mt) {
        this(mt, (MessageMetadataStrategy)new DefaultMtMetadataStrategy());
    }

    public MtSwiftMessage(AbstractMT mt, MessageMetadataStrategy metadataStrategy) {
        Objects.requireNonNull(mt, "the mt message cannot be null");
        Objects.requireNonNull(metadataStrategy, "the strategy for metadata extraction cannot be null");
        this.updateFromModel(mt.getSwiftMessage(), metadataStrategy);
    }

    public MtSwiftMessage(SwiftMessage model) {
        this(model, (MessageMetadataStrategy)new DefaultMtMetadataStrategy());
    }

    public MtSwiftMessage(SwiftMessage model, MessageMetadataStrategy metadataStrategy) {
        Objects.requireNonNull(model, "the message model cannot be null");
        Objects.requireNonNull(metadataStrategy, "the strategy for metadata extraction cannot be null");
        this.updateFromModel(model, metadataStrategy);
    }

    public static MtSwiftMessage parse(String fin) {
        return new MtSwiftMessage(fin);
    }

    public static MtSwiftMessage parse(InputStream stream) throws IOException {
        return new MtSwiftMessage(stream);
    }

    public static MtSwiftMessage parse(File file) throws IOException {
        return new MtSwiftMessage(file);
    }

    public static MtSwiftMessage fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (MtSwiftMessage)gson.fromJson(json, MtSwiftMessage.class);
    }

    @Override
    protected void updateFromMessage() throws IllegalArgumentException {
        this.updateFromMessage(new DefaultMtMetadataStrategy());
    }

    @Override
    protected void updateFromMessage(MessageMetadataStrategy metadataStrategy) throws IllegalArgumentException {
        Objects.requireNonNull(metadataStrategy, "the strategy for metadata extraction cannot be null");
        Objects.requireNonNull(this.getMessage(), "the raw message attribute cannot be null");
        if (this.getFileFormat() != FileFormat.FIN) {
            throw new IllegalArgumentException("expected source format " + (Object)((Object)FileFormat.FIN) + " and found " + (Object)((Object)this.getFileFormat()));
        }
        SwiftMessage model = null;
        try {
            model = SwiftMessage.parse(this.getMessage());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "the raw message parameter could not be parsed into a SwiftMessage", e);
        }
        if (model == null) {
            throw new IllegalArgumentException("the raw message parameter could not be parsed into a SwiftMessage");
        }
        this.updateAttributes(model, metadataStrategy);
    }

    private void updateAttributes(SwiftMessage model, MessageMetadataStrategy metadataStrategy) {
        if (model.isServiceMessage21()) {
            SwiftMessage original;
            if (model.getUnparsedTextsSize() > 0 && (original = model.getUnparsedTexts().getTextAsMessage(0)) != null) {
                this.extractMetadata(original, metadataStrategy);
            }
            if (model.isAck()) {
                this.setIdentifier("ACK");
            } else if (model.isNack()) {
                this.setIdentifier("NAK");
            }
        } else {
            this.extractMetadata(model, metadataStrategy);
            if (model.getMtId() != null) {
                this.setIdentifier(model.getMtId().id());
            }
        }
        this.setFileFormat(FileFormat.FIN);
        this.setSender(this.bic11(model.getSender()));
        this.setChecksum(SwiftMessageUtils.calculateChecksum(model));
        this.setChecksumBody(SwiftMessageUtils.calculateChecksum(model.getBlock4()));
        this.setLastModified(Calendar.getInstance());
        this.setMur(model.getMUR());
    }

    private void extractMetadata(SwiftMessage model, MessageMetadataStrategy metadataStrategy) {
        this.setReceiver(this.bic11(model.getReceiver()));
        this.setDirection(model.getDirection());
        this.setPde(model.getPDE());
        this.setPdm(model.getPDM());
        this.setMir(model.getMIR());
        if (model.getBlock2() != null) {
            this.setUuid(model.getUUID());
        }
        this.applyStrategy(model, metadataStrategy);
    }

    private void applyStrategy(SwiftMessage model, MessageMetadataStrategy strategy) {
        Optional<Money> money;
        AbstractMT mt = model.toMT();
        if (mt == null) {
            return;
        }
        String reference = strategy.reference(mt).orElse(null);
        if (StringUtils.isNotBlank((CharSequence)reference)) {
            this.setReference(reference);
        }
        if ((money = strategy.amount(mt)).isPresent()) {
            this.setCurrency(money.get().getCurrency());
            this.setAmount(money.get().getAmount());
        }
        strategy.valueDate(mt).ifPresent(this::setValueDate);
        strategy.tradeDate(mt).ifPresent(this::setTradeDate);
    }

    public void updateFromFIN(String fin) {
        this.updateFromFIN(fin, new DefaultMtMetadataStrategy());
    }

    public void updateFromFIN(String fin, MessageMetadataStrategy metadataStrategy) {
        Objects.requireNonNull(fin, "the raw message parameter cannot be null");
        Objects.requireNonNull(metadataStrategy, "the strategy for metadata extraction cannot be null");
        this.setMessage(fin);
        this.setFileFormat(FileFormat.FIN);
        this.updateFromMessage(metadataStrategy);
    }

    @Deprecated
    public void updateFromFIN() {
        DeprecationUtils.phase3(this.getClass(), "updateFromFIN()", "Use updateFromFIN(String) instead");
        this.updateFromMessage();
    }

    public void updateFromModel(SwiftMessage model) {
        this.updateFromModel(model, (MessageMetadataStrategy)new DefaultMtMetadataStrategy());
    }

    public void updateFromModel(SwiftMessage model, MessageMetadataStrategy metadataStrategy) {
        Objects.requireNonNull(model, "the model message cannot be null");
        Objects.requireNonNull(metadataStrategy, "the metadata strategy cannot be null");
        String fin = new ConversionService().getFIN(model);
        Objects.requireNonNull(fin, "the raw message could not be created from the SwiftMessage parameter");
        this.setMessage(fin);
        this.updateAttributes(model, metadataStrategy);
    }

    public void updateFromModel(AbstractMT mt) {
        this.updateFromModel(mt, (MessageMetadataStrategy)new DefaultMtMetadataStrategy());
    }

    public void updateFromModel(AbstractMT mt, MessageMetadataStrategy metadataStrategy) {
        Objects.requireNonNull(mt, "the model message cannot be null");
        Objects.requireNonNull(metadataStrategy, "the metadata strategy cannot be null");
        this.updateFromModel(mt.getSwiftMessage(), metadataStrategy);
    }

    public SwiftMessage modelMessage() {
        if (this.getMessage() != null) {
            try {
                return SwiftMessage.parse(this.message());
            }
            catch (IOException e) {
                log.log(Level.WARNING, "error converting FIN text to model: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public Integer getMessageTypeInt() {
        String number = this.getMessageType();
        if (StringUtils.isNumeric((CharSequence)number)) {
            return Integer.parseInt(number);
        }
        return null;
    }

    @Override
    public String getMessageName() {
        String name = super.getMessageName();
        if (name != null) {
            return name;
        }
        return this.getMessageType();
    }

    public boolean isType(Integer ... type) {
        for (Integer integer : type) {
            if (!this.isType((int)integer)) continue;
            return true;
        }
        return false;
    }

    public boolean isType(int type) {
        Integer typeInt = this.getMessageTypeInt();
        if (typeInt != null) {
            return typeInt == type;
        }
        return false;
    }

    public String toString() {
        return "MtSwiftMessage id=" + this.getId() + " message=" + this.getMessage();
    }

    public String getPde() {
        return this.pde;
    }

    public void setPde(String pde) {
        this.pde = pde;
    }

    public String getPdm() {
        return this.pdm;
    }

    public void setPdm(String pdm) {
        this.pdm = pdm;
    }

    public String getMir() {
        return this.mir;
    }

    public void setMir(String mir) {
        this.mir = mir;
    }

    public String getMur() {
        return this.mur;
    }

    public void setMur(String mur) {
        this.mur = mur;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MtSwiftMessage that = (MtSwiftMessage)o;
        return Objects.equals(this.pde, that.pde) && Objects.equals(this.pdm, that.pdm) && Objects.equals(this.mir, that.mir) && Objects.equals(this.mur, that.mur) && Objects.equals(this.uuid, that.uuid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pde, this.pdm, this.mir, this.mur, this.uuid);
    }

    public void copyTo(MtSwiftMessage msg) {
        super.copyTo(msg);
        msg.setMir(this.getMir());
        msg.setMur(this.getMur());
        msg.setPde(this.getPde());
        msg.setPdm(this.getPdm());
        msg.setUuid(this.getUuid());
    }

    public MTVariant getVariant() {
        String s = StringUtils.substringAfterLast((String)this.identifier, (String)".");
        if (EnumUtils.isValidEnum(MTVariant.class, (String)s)) {
            return MTVariant.valueOf(s);
        }
        return null;
    }

    public MtId getMtId() {
        return new MtId(this.getMessageType(), this.getVariant());
    }

    @Override
    public String getCategory() {
        if (!StringUtils.isBlank((CharSequence)this.identifier)) {
            return new MtId(this.identifier).category();
        }
        return "";
    }

    public void updateMetadata(MessageMetadataStrategy strategy) {
        Objects.requireNonNull(strategy, "the strategy for metadata extraction cannot be null");
        this.applyStrategy(this.modelMessage(), strategy);
    }
}

