/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.gradle.pride.vcs.svn;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.prezi.gradle.pride.ProcessUtils;
import com.prezi.gradle.pride.vcs.VcsStatus;
import com.prezi.gradle.pride.vcs.VcsSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvnVcsSupport
implements VcsSupport {
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("^(?:svn|https?)://.+/(.+?)(?:\\.git)?/?$", 4);
    private static final Pattern REVISION = Pattern.compile("Revision: (.*)");
    private static final Pattern ROOT_URL = Pattern.compile("Repository Root: (.*)");
    private static final Logger log = LoggerFactory.getLogger(SvnVcsSupport.class);

    public void checkout(String repositoryUrl, File targetDirectory, String revision, boolean recursive, boolean mirrored) throws IOException {
        FileUtils.forceMkdir((File)targetDirectory.getParentFile());
        FileUtils.deleteQuietly((File)targetDirectory);
        String branchUrl = new RepositoryUrl(repositoryUrl, revision).toUrl();
        log.debug("Checking out {} into {}", (Object)branchUrl, (Object)targetDirectory);
        ImmutableList.Builder checkoutCommand = ImmutableList.builder().add((Object)"svn").add((Object)"checkout");
        if (!recursive) {
            checkoutCommand.add((Object)"--depth=files");
        }
        checkoutCommand.add((Object)branchUrl).add((Object)targetDirectory.getPath());
        ProcessUtils.executeIn(null, (List)checkoutCommand.build());
    }

    public void update(File targetDirectory, String revision, boolean recursive, boolean mirrored) throws IOException {
        ImmutableList.Builder updateCommand = ImmutableList.builder();
        if (!Strings.isNullOrEmpty((String)revision) && !revision.equals(this.getBranch(targetDirectory))) {
            updateCommand.add((Object[])new String[]{"svn", "switch", this.getRepositoryUrl(targetDirectory) + "/" + revision, "."});
        } else {
            updateCommand.add((Object[])new String[]{"svn", "update"});
        }
        if (!recursive) {
            updateCommand.add((Object)"--depth=files");
        }
        ProcessUtils.executeIn((File)targetDirectory, (List)updateCommand.build());
    }

    public boolean hasChanges(File targetDirectory) throws IOException {
        Process process = ProcessUtils.executeIn((File)targetDirectory, Arrays.asList("svn", "status"), (boolean)false, (boolean)false);
        String result = new String(ByteStreams.toByteArray((InputStream)process.getInputStream()), Charsets.UTF_8);
        return !result.trim().isEmpty();
    }

    public VcsStatus getStatus(File targetDirectory) throws IOException {
        VcsStatus.Builder status = VcsStatus.builder((String)this.getRevision(targetDirectory));
        status.withUncommittedChanges(this.hasChanges(targetDirectory));
        status.withBranch(this.getBranch(targetDirectory));
        return status.build();
    }

    private String getRevision(File targetDirectory) throws IOException {
        return this.getInfoValue(targetDirectory, REVISION);
    }

    public void activate(String repositoryUrl, File targetDirectory) throws IOException {
        throw new AssertionError((Object)"Cannot activate an SVN repository");
    }

    public boolean isMirroringSupported() {
        return false;
    }

    public String getRepositoryUrl(File targetDirectory) throws IOException {
        return this.getRepositoryUrlInternal((File)targetDirectory).root;
    }

    public String getBranch(File targetDirectory) throws IOException {
        return this.getRepositoryUrlInternal((File)targetDirectory).branch;
    }

    public String getDefaultBranch() throws IOException {
        return "trunk";
    }

    private RepositoryUrl getRepositoryUrlInternal(File targetDirectory) throws IOException {
        String fullUrl = this.getInfoValue(targetDirectory, ROOT_URL);
        return RepositoryUrl.fromString(fullUrl);
    }

    private String getInfoValue(File targetDirectory, Pattern pattern) throws IOException {
        Process process = ProcessUtils.executeIn((File)targetDirectory, Arrays.asList("svn", "info"), (boolean)false, (boolean)false);
        List infoLines = CharStreams.readLines((Readable)new InputStreamReader(process.getInputStream(), Charsets.UTF_8));
        for (String remoteLine : infoLines) {
            Matcher matcher = pattern.matcher(remoteLine);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    public String normalizeRepositoryUrl(String repositoryUrl) {
        return repositoryUrl;
    }

    public String resolveRepositoryName(String repository) {
        Matcher matcher = REPOSITORY_NAME_PATTERN.matcher(repository);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static class RepositoryUrl {
        public static final String TRUNK = "trunk";
        private static Pattern URL_PATTERN = Pattern.compile("(.*)/(?:trunk|branches/([^/]+))/?");
        public final String root;
        public final String branch;

        private RepositoryUrl(String root, String branch) {
            this.root = root;
            this.branch = Strings.isNullOrEmpty((String)branch) ? TRUNK : branch;
        }

        public static RepositoryUrl fromString(String url) {
            Matcher matcher = URL_PATTERN.matcher(url);
            if (matcher.matches()) {
                return new RepositoryUrl(matcher.group(1), matcher.group(2));
            }
            throw new IllegalArgumentException("Unable to parse URL: " + url);
        }

        public String toUrl() {
            if (TRUNK.equals(this.branch)) {
                return this.root + "/" + TRUNK;
            }
            return this.root + "/branches/" + this.branch;
        }
    }
}

