/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CFactory;
import com.pi4j.io.i2c.I2CFactoryProvider;
import com.pi4j.io.i2c.impl.I2CBusImpl;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class I2CProviderImpl
implements I2CFactoryProvider {
    @Override
    public I2CBus getBus(int busNumber, long lockAquireTimeout, TimeUnit lockAquireTimeoutUnit) throws I2CFactory.UnsupportedBusNumberException, IOException {
        File sysfs = new File("/sys/bus/i2c/devices/i2c-" + busNumber);
        if (!sysfs.exists() || !sysfs.isDirectory()) {
            throw new I2CFactory.UnsupportedBusNumberException();
        }
        File devfs = new File("/dev/i2c-" + busNumber);
        if (!(devfs.exists() && devfs.canRead() && devfs.canWrite())) {
            throw new I2CFactory.UnsupportedBusNumberException();
        }
        I2CBusImpl result = new I2CBusImpl(busNumber, devfs.getCanonicalPath(), lockAquireTimeout, lockAquireTimeoutUnit);
        result.open();
        return result;
    }
}

