/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.dione.spark.index.sequence;

import com.paypal.dione.hdfs.index.sequence.SequenceFileIndexer;
import com.paypal.dione.spark.index.sequence.SeqFileUtils;
import com.paypal.dione.spark.index.sequence.SeqFileUtils$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.hive.SparkSqlHiveUtils$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SeqFileUtils$ {
    public static final SeqFileUtils$ MODULE$;

    static {
        new SeqFileUtils$();
    }

    public SequenceFileIndexer.Deserializer createDeserializer(SeqFileUtils.SerDeInfo serde, StructType inputSchema, Seq<String> outputFields, Configuration conf) {
        Deserializer tableSerDe = serde.getTableSerde(conf);
        Deserializer partitionSerDe = serde.getPartitionSerde(conf);
        StructObjectInspector objectInspector = this.createObjectInspector(tableSerDe, partitionSerDe);
        org.apache.hadoop.hive.serde2.objectinspector.StructField[] inputHiveSchema = (org.apache.hadoop.hive.serde2.objectinspector.StructField[])((TraversableOnce)((TraversableLike)inputSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$1) {
                return x$1.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(objectInspector){
            public static final long serialVersionUID = 0L;
            private final StructObjectInspector objectInspector$1;

            public final org.apache.hadoop.hive.serde2.objectinspector.StructField apply(String x$1) {
                return this.objectInspector$1.getStructFieldRef(x$1);
            }
            {
                this.objectInspector$1 = objectInspector$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(org.apache.hadoop.hive.serde2.objectinspector.StructField.class));
        Map inputHiveSchemaWithIndex = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])inputHiveSchema).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(org.apache.hadoop.hive.serde2.objectinspector.StructField x$2) {
                return x$2.getFieldName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Seq outputFieldsWithPosition = (Seq)outputFields.map((Function1)new Serializable(inputHiveSchemaWithIndex){
            public static final long serialVersionUID = 0L;
            private final Map inputHiveSchemaWithIndex$1;

            public final Tuple2<String, Object> apply(String outputField) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)outputField), this.inputHiveSchemaWithIndex$1.apply((Object)outputField));
            }
            {
                this.inputHiveSchemaWithIndex$1 = inputHiveSchemaWithIndex$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)partitionSerDe.getObjectInspector(), (ObjectInspector)objectInspector);
        SequenceFileIndexer.Deserializer deserializer = new SequenceFileIndexer.Deserializer(partitionSerDe, objectInspector, inputHiveSchema, outputFieldsWithPosition, converter){
            private final Deserializer partitionSerDe$1;
            public final StructObjectInspector objectInspector$1;
            public final org.apache.hadoop.hive.serde2.objectinspector.StructField[] inputHiveSchema$1;
            private final Seq outputFieldsWithPosition$1;
            private final ObjectInspectorConverters.Converter converter$1;

            public Seq<Tuple2<String, Object>> deserialize(Writable k, Writable v) {
                Object deserialized = this.partitionSerDe$1.deserialize(v);
                Object raw = this.converter$1.convert(deserialized);
                return (Seq)this.outputFieldsWithPosition$1.map((Function1)new Serializable(this, raw){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final Object raw$1;

                    public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object object;
                            Object hiveObject;
                            String name = (String)tuple2._1();
                            int positionInSchema = tuple2._2$mcI$sp();
                            org.apache.hadoop.hive.serde2.objectinspector.StructField field = this.$outer.inputHiveSchema$1[positionInSchema];
                            Object object2 = SeqFileUtils$.MODULE$.unwrap(field, hiveObject = this.$outer.objectInspector$1.getStructFieldData(this.raw$1, field));
                            if (object2 instanceof UTF8String) {
                                UTF8String uTF8String = (UTF8String)object2;
                                object = uTF8String.toString();
                            } else {
                                object = object2;
                            }
                            Object unwrapped = object;
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), unwrapped);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.raw$1 = raw$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.partitionSerDe$1 = partitionSerDe$1;
                this.objectInspector$1 = objectInspector$1;
                this.inputHiveSchema$1 = inputHiveSchema$1;
                this.outputFieldsWithPosition$1 = outputFieldsWithPosition$1;
                this.converter$1 = converter$1;
            }
        };
        return deserializer;
    }

    public StructObjectInspector createObjectInspector(Deserializer tableSerDe, Deserializer partitionsSerDe) {
        return partitionsSerDe.getObjectInspector().equals(tableSerDe.getObjectInspector()) ? (StructObjectInspector)partitionsSerDe.getObjectInspector() : (StructObjectInspector)ObjectInspectorConverters.getConvertedOI((ObjectInspector)partitionsSerDe.getObjectInspector(), (ObjectInspector)tableSerDe.getObjectInspector());
    }

    public Object unwrap(org.apache.hadoop.hive.serde2.objectinspector.StructField field, Object hiveObject) {
        Object object;
        ObjectInspector objectInspector = field.getFieldObjectInspector();
        if (hiveObject == null) {
            object = null;
        } else if (objectInspector instanceof BooleanObjectInspector) {
            BooleanObjectInspector booleanObjectInspector = (BooleanObjectInspector)objectInspector;
            object = BoxesRunTime.boxToBoolean((boolean)booleanObjectInspector.get(hiveObject));
        } else if (objectInspector instanceof ByteObjectInspector) {
            ByteObjectInspector byteObjectInspector = (ByteObjectInspector)objectInspector;
            object = BoxesRunTime.boxToByte((byte)byteObjectInspector.get(hiveObject));
        } else if (objectInspector instanceof ShortObjectInspector) {
            ShortObjectInspector shortObjectInspector = (ShortObjectInspector)objectInspector;
            object = BoxesRunTime.boxToShort((short)shortObjectInspector.get(hiveObject));
        } else if (objectInspector instanceof IntObjectInspector) {
            IntObjectInspector intObjectInspector = (IntObjectInspector)objectInspector;
            object = BoxesRunTime.boxToInteger((int)intObjectInspector.get(hiveObject));
        } else if (objectInspector instanceof LongObjectInspector) {
            LongObjectInspector longObjectInspector = (LongObjectInspector)objectInspector;
            object = BoxesRunTime.boxToLong((long)longObjectInspector.get(hiveObject));
        } else if (objectInspector instanceof FloatObjectInspector) {
            FloatObjectInspector floatObjectInspector = (FloatObjectInspector)objectInspector;
            object = BoxesRunTime.boxToFloat((float)floatObjectInspector.get(hiveObject));
        } else if (objectInspector instanceof DoubleObjectInspector) {
            DoubleObjectInspector doubleObjectInspector = (DoubleObjectInspector)objectInspector;
            object = BoxesRunTime.boxToDouble((double)doubleObjectInspector.get(hiveObject));
        } else if (objectInspector instanceof HiveVarcharObjectInspector) {
            HiveVarcharObjectInspector hiveVarcharObjectInspector = (HiveVarcharObjectInspector)objectInspector;
            object = UTF8String.fromString((String)hiveVarcharObjectInspector.getPrimitiveJavaObject(hiveObject).getValue());
        } else if (objectInspector instanceof HiveCharObjectInspector) {
            HiveCharObjectInspector hiveCharObjectInspector = (HiveCharObjectInspector)objectInspector;
            object = UTF8String.fromString((String)hiveCharObjectInspector.getPrimitiveJavaObject(hiveObject).getValue());
        } else if (objectInspector instanceof HiveDecimalObjectInspector) {
            HiveDecimalObjectInspector hiveDecimalObjectInspector = (HiveDecimalObjectInspector)objectInspector;
            object = hiveDecimalObjectInspector.getPrimitiveJavaObject(hiveObject).bigDecimalValue();
        } else if (objectInspector instanceof TimestampObjectInspector) {
            TimestampObjectInspector timestampObjectInspector = (TimestampObjectInspector)objectInspector;
            object = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(timestampObjectInspector.getPrimitiveJavaObject(hiveObject)));
        } else if (objectInspector instanceof DateObjectInspector) {
            DateObjectInspector dateObjectInspector = (DateObjectInspector)objectInspector;
            object = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(dateObjectInspector.getPrimitiveJavaObject(hiveObject)));
        } else if (objectInspector instanceof BinaryObjectInspector) {
            BinaryObjectInspector binaryObjectInspector = (BinaryObjectInspector)objectInspector;
            object = binaryObjectInspector.getPrimitiveJavaObject(hiveObject);
        } else {
            Function1<Object, Object> unwrapper = SparkSqlHiveUtils$.MODULE$.hiveUnwrapperFor(objectInspector);
            object = unwrapper.apply(hiveObject);
        }
        return object;
    }

    private SeqFileUtils$() {
        MODULE$ = this;
    }
}

