/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.dione.spark.index;

import com.paypal.dione.spark.index.IndexReader;
import com.paypal.dione.spark.index.IndexReader$;
import com.paypal.dione.spark.index.IndexReader$Accumulator$4$;
import com.paypal.dione.spark.index.SparkIndexer;
import com.paypal.dione.spark.metrics.StatsReporter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileObjectRef;

public final class IndexReader$
implements Serializable {
    public static final IndexReader$ MODULE$;
    private final Logger com$paypal$dione$spark$index$IndexReader$$logger;

    static {
        new IndexReader$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IndexReader$Accumulator$4$ com$paypal$dione$spark$index$IndexReader$$Accumulator$2$lzycompute(VolatileObjectRef x$1) {
        IndexReader$ indexReader$ = this;
        synchronized (indexReader$) {
            if (x$1.elem != null) return (IndexReader$Accumulator$4$)((Object)x$1.elem);
            x$1.elem = new IndexReader$Accumulator$4$();
            return (IndexReader$Accumulator$4$)((Object)x$1.elem);
        }
    }

    public Logger com$paypal$dione$spark$index$IndexReader$$logger() {
        return this.com$paypal$dione$spark$index$IndexReader$$logger;
    }

    public Dataset<Row> read(Dataset<Row> rawIndex, IndexReader reader) {
        Dataset cleanIndex = rawIndex.drop((Seq)reader.fieldsSchema().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$2) {
                return x$2.name();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        StructType outputSchema = StructType$.MODULE$.apply((Seq)cleanIndex.schema().$plus$plus((GenTraversableOnce)reader.fieldsSchema(), Seq$.MODULE$.canBuildFrom()));
        SparkSession spark = rawIndex.sparkSession();
        boolean readInChunks = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("indexer.reader.chunks", "false"))).toBoolean();
        Dataset readerDF = readInChunks ? this.preparePartitionsInChunks((Dataset<Row>)cleanIndex) : cleanIndex.repartition((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("data_filename")})).sortWithinPartitions("data_filename", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data_offset", "data_sub_offset"}));
        return readerDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])cleanIndex.columns()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).mapPartitions((Function1)new Serializable(reader){
            public static final long serialVersionUID = 0L;
            private final IndexReader reader$1;

            public final Iterator<Row> apply(Iterator<Row> iter) {
                return this.reader$1.mapPartitions(iter);
            }
            {
                this.reader$1 = reader$1;
            }
        }, (Encoder)RowEncoder$.MODULE$.apply(outputSchema));
    }

    /*
     * WARNING - void declaration
     */
    public StatsReporter getReporter(SparkSession spark) {
        void var2_4;
        String string = spark.conf().get("indexer.reader.reporter", null);
        StatsReporter statsReporter = string == null ? new StatsReporter.SoftReporter() : ("none".equals(string) ? new StatsReporter() : (StatsReporter)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]));
        StatsReporter.SoftReporter reporter = statsReporter;
        return var2_4;
    }

    public Dataset<Row> preparePartitionsInChunks(Dataset<Row> keysDF) {
        Dataset dataset;
        SparkSession spark = keysDF.sparkSession();
        boolean isDebug = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("indexer.reader.debug", "false"))).toBoolean();
        int repartitionRatio = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("indexer.reader.repartitionRatio", "100"))).toInt();
        int shufflePartitions = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("spark.sql.shuffle.partitions"))).toInt();
        int partitions = scala.math.package$.MODULE$.max(shufflePartitions / repartitionRatio, 1);
        Dataset reducedPartitionsDF = keysDF.repartition(partitions, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("data_filename")}))})).sortWithinPartitions("data_filename", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data_offset", "data_sub_offset"}));
        int maxChunkSize = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("indexer.reader.maxBytes", ((Object)BoxesRunTime.boxToInteger((int)0x1400000)).toString()))).toInt();
        Dataset<Row> accumulatedBytesDF = this.sumPartitionBytes((Dataset<Row>)reducedPartitionsDF);
        Dataset chunkedDF = accumulatedBytesDF.withColumn("__chunk", spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"__sum"}))).$((Seq)Nil$.MODULE$).$div((Object)BoxesRunTime.boxToInteger((int)maxChunkSize)).cast("int")).repartition((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.spark_partition_id()})), functions$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"__chunk"}))).$((Seq)Nil$.MODULE$)}))})).sortWithinPartitions("data_filename", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data_offset", "data_sub_offset"}));
        if (isDebug) {
            this.printChunksStats((Dataset<Row>)chunkedDF);
            dataset = chunkedDF;
        } else {
            dataset = chunkedDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])keysDF.columns()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(String colName) {
                    return functions$.MODULE$.col(colName);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        }
        return dataset;
    }

    public Dataset<Row> sumPartitionBytes(Dataset<Row> reducedPartitionsDF) {
        VolatileObjectRef Accumulator$module = VolatileObjectRef.zero();
        int newFileCostInBytes = new StringOps(Predef$.MODULE$.augmentString(reducedPartitionsDF.sparkSession().conf().get("indexer.reader.newFileCostInBytes", ((Object)BoxesRunTime.boxToInteger((int)0x100000)).toString()))).toInt();
        return reducedPartitionsDF.mapPartitions((Function1)new Serializable(newFileCostInBytes, Accumulator$module){
            public static final long serialVersionUID = 0L;
            public final int newFileCostInBytes$1;
            public final VolatileObjectRef Accumulator$module$1;

            public final Iterator<Row> apply(Iterator<Row> iter) {
                public class Com_paypal_dione_spark_index_IndexReader$Accumulator$3
                implements Product,
                Serializable {
                    private final Row row;
                    private final String file;
                    private final long accSum;
                    private final long count;

                    public Row row() {
                        return this.row;
                    }

                    public String file() {
                        return this.file;
                    }

                    public long accSum() {
                        return this.accSum;
                    }

                    public long count() {
                        return this.count;
                    }

                    public Com_paypal_dione_spark_index_IndexReader$Accumulator$3 copy(Row row, String file, long accSum, long count) {
                        return new Com_paypal_dione_spark_index_IndexReader$Accumulator$3(row, file, accSum, count);
                    }

                    public Row copy$default$1() {
                        return this.row();
                    }

                    public String copy$default$2() {
                        return this.file();
                    }

                    public long copy$default$3() {
                        return this.accSum();
                    }

                    public long copy$default$4() {
                        return this.count();
                    }

                    public String productPrefix() {
                        return "Accumulator";
                    }

                    public int productArity() {
                        return 4;
                    }

                    public Object productElement(int x$1) {
                        Object object;
                        int n = x$1;
                        switch (n) {
                            default: {
                                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                            }
                            case 3: {
                                object = BoxesRunTime.boxToLong((long)this.count());
                                break;
                            }
                            case 2: {
                                object = BoxesRunTime.boxToLong((long)this.accSum());
                                break;
                            }
                            case 1: {
                                object = this.file();
                                break;
                            }
                            case 0: {
                                object = this.row();
                            }
                        }
                        return object;
                    }

                    public Iterator<Object> productIterator() {
                        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                    }

                    public boolean canEqual(Object x$1) {
                        return x$1 instanceof Com_paypal_dione_spark_index_IndexReader$Accumulator$3;
                    }

                    public int hashCode() {
                        int n = -889275714;
                        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.row()));
                        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.file()));
                        n = Statics.mix((int)n, (int)Statics.longHash((long)this.accSum()));
                        n = Statics.mix((int)n, (int)Statics.longHash((long)this.count()));
                        return Statics.finalizeHash((int)n, (int)4);
                    }

                    public String toString() {
                        return ScalaRunTime$.MODULE$._toString((Product)this);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object x$1) {
                        if (this == x$1) return true;
                        Object object = x$1;
                        if (!(object instanceof Com_paypal_dione_spark_index_IndexReader$Accumulator$3)) return false;
                        boolean bl = true;
                        if (!bl) return false;
                        Com_paypal_dione_spark_index_IndexReader$Accumulator$3 var4_4 = (Com_paypal_dione_spark_index_IndexReader$Accumulator$3)x$1;
                        Row row = this.row();
                        Row row2 = var4_4.row();
                        if (row == null) {
                            if (row2 != null) {
                                return false;
                            }
                        } else if (!row.equals(row2)) return false;
                        String string = this.file();
                        String string2 = var4_4.file();
                        if (string == null) {
                            if (string2 != null) {
                                return false;
                            }
                        } else if (!string.equals(string2)) return false;
                        if (this.accSum() != var4_4.accSum()) return false;
                        if (this.count() != var4_4.count()) return false;
                        if (!var4_4.canEqual(this)) return false;
                        return true;
                    }

                    public Com_paypal_dione_spark_index_IndexReader$Accumulator$3(Row row, String file, long accSum, long count) {
                        this.row = row;
                        this.file = file;
                        this.accSum = accSum;
                        this.count = count;
                        Product.class.$init$((Product)this);
                    }
                }
                return iter.scanLeft((Object)IndexReader$.MODULE$.com$paypal$dione$spark$index$IndexReader$$Accumulator$2(this.Accumulator$module$1).apply(Row$.MODULE$.apply((Seq)Nil$.MODULE$), null, 0L, 0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sumPartitionBytes.1 $outer;

                    public final Com_paypal_dione_spark_index_IndexReader$Accumulator$3 apply(Com_paypal_dione_spark_index_IndexReader$Accumulator$3 x0$1, Row x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            Com_paypal_dione_spark_index_IndexReader$Accumulator$3 var4_4 = (Com_paypal_dione_spark_index_IndexReader$Accumulator$3)tuple2._1();
                            Row row = (Row)tuple2._2();
                            if (var4_4 != null) {
                                String currentFile;
                                String file = var4_4.file();
                                long acc = var4_4.accSum();
                                long count = var4_4.count();
                                String string = currentFile = row.getAs("data_filename").toString();
                                String string2 = file;
                                int cost = !(string != null ? !string.equals(string2) : string2 != null) ? 0 : this.$outer.newFileCostInBytes$1;
                                long sum = acc + (long)BoxesRunTime.unboxToInt((Object)row.getAs("data_size")) + (long)cost;
                                Row rowWithAccSum = Row$.MODULE$.fromSeq((Seq)row.toSeq().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{sum})), Seq$.MODULE$.canBuildFrom()));
                                Com_paypal_dione_spark_index_IndexReader$Accumulator$3 var11_14 = IndexReader$.MODULE$.com$paypal$dione$spark$index$IndexReader$$Accumulator$2(this.$outer.Accumulator$module$1).apply(rowWithAccSum, currentFile, sum, count + 1L);
                                return var11_14;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).drop(1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Row apply(Com_paypal_dione_spark_index_IndexReader$Accumulator$3 x$3) {
                        return x$3.row();
                    }
                });
            }
            {
                this.newFileCostInBytes$1 = newFileCostInBytes$1;
                this.Accumulator$module$1 = Accumulator$module$1;
            }
        }, (Encoder)RowEncoder$.MODULE$.apply(reducedPartitionsDF.schema().add("__sum", (DataType)LongType$.MODULE$)));
    }

    private void printChunksStats(Dataset<Row> chunkedDF) {
        SparkSession spark = chunkedDF.sparkSession();
        chunkedDF.explain();
        long chunks = chunkedDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"__chunk"}))).$((Seq)Nil$.MODULE$)})).distinct().count();
        this.com$paypal$dione$spark$index$IndexReader$$logger().info(new StringBuilder().append((Object)"number of chunks: ").append((Object)BoxesRunTime.boxToLong((long)chunks)).toString());
        this.com$paypal$dione$spark$index$IndexReader$$logger().info("chunks distribution:");
        Tuple2[] partitions = (Tuple2[])chunkedDF.rdd().mapPartitions((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple2<Object, Object>> apply(Iterator<Row> iter) {
                List list = iter.toList();
                Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)list.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Row row) {
                        return BoxesRunTime.unboxToInt((Object)row.getAs("data_size"));
                    }
                }, List$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2.mcJI.sp(0L, 0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$2, int x1$2) {
                        Tuple2 tuple2 = new Tuple2(x0$2, (Object)BoxesRunTime.boxToInteger((int)x1$2));
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            int size = tuple2._2$mcI$sp();
                            if (tuple22 != null) {
                                long sum = tuple22._1$mcJ$sp();
                                int length = tuple22._2$mcI$sp();
                                Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(sum + (long)size, length + 1);
                                return sp2;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                });
                if (tuple2 != null) {
                    Tuple2.mcJI.sp sp2;
                    long sum = tuple2._1$mcJ$sp();
                    int len = tuple2._2$mcI$sp();
                    Tuple2.mcJI.sp sp3 = sp2 = new Tuple2.mcJI.sp(sum, len);
                    long sum2 = sp3._1$mcJ$sp();
                    int len2 = sp3._2$mcI$sp();
                    return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJI.sp(sum2, len2)}));
                }
                throw new MatchError((Object)tuple2);
            }
        }, chunkedDF.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        Predef$.MODULE$.refArrayOps((Object[])partitions).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    long sum = tuple2._1$mcJ$sp();
                    int len = tuple2._2$mcI$sp();
                    IndexReader$.MODULE$.com$paypal$dione$spark$index$IndexReader$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition size, length: [", ", ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sum), BoxesRunTime.boxToInteger((int)len)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public IndexReader apply(SparkSession spark, SparkIndexer sparkIndexer, StructType fieldsSchema, boolean ignoreFailures) {
        return new IndexReader(spark, sparkIndexer, fieldsSchema, ignoreFailures);
    }

    public Option<Tuple4<SparkSession, SparkIndexer, StructType, Object>> unapply(IndexReader x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.spark(), (Object)x$0.sparkIndexer(), (Object)x$0.fieldsSchema(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ignoreFailures())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final IndexReader$Accumulator$4$ com$paypal$dione$spark$index$IndexReader$$Accumulator$2(VolatileObjectRef Accumulator$module$1) {
        return Accumulator$module$1.elem == null ? this.com$paypal$dione$spark$index$IndexReader$$Accumulator$2$lzycompute(Accumulator$module$1) : (IndexReader$Accumulator$4$)((Object)Accumulator$module$1.elem);
    }

    private IndexReader$() {
        MODULE$ = this;
        this.com$paypal$dione$spark$index$IndexReader$$logger = LoggerFactory.getLogger(this.getClass());
    }
}

