/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.dione.spark.index;

import com.paypal.dione.hdfs.index.HdfsIndexerMetadata;
import com.paypal.dione.spark.index.IndexManager;
import com.paypal.dione.spark.index.IndexManager$;
import com.paypal.dione.spark.index.IndexManagerFactory;
import com.paypal.dione.spark.index.IndexManagerUtils$;
import com.paypal.dione.spark.index.IndexManagerUtils$$anon$1$;
import com.paypal.dione.spark.index.IndexManagerUtils$$anonfun$4$;
import com.paypal.dione.spark.index.IndexSpec;
import com.paypal.dione.spark.index.SparkIndexer;
import com.paypal.dione.spark.index.avro.AvroSparkIndexer$;
import com.paypal.dione.spark.index.orc.OrcSparkIndexer$;
import com.paypal.dione.spark.index.parquet.ParquetSparkIndexer$;
import com.paypal.dione.spark.index.sequence.SeqFileSparkIndexer$;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.dione.Metrics$;
import org.apache.spark.dione.ReaderMetrics;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hive.SerializableConfiguration;
import org.apache.spark.sql.hive.SerializableConfiguration$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class IndexManagerUtils$ {
    public static final IndexManagerUtils$ MODULE$;
    private final Logger com$paypal$dione$spark$index$IndexManagerUtils$$logger;
    private static Class[] reflParams$Cache1;
    private static volatile SoftReference reflPoly$Cache1;
    private static Class[] reflParams$Cache2;
    private static volatile SoftReference reflPoly$Cache2;

    static {
        reflParams$Cache1 = new Class[0];
        reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
        reflParams$Cache2 = new Class[0];
        reflPoly$Cache2 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
        new IndexManagerUtils$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        Method method1;
        MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
        if (methodCache1 == null) {
            methodCache1 = new EmptyMethodCache();
            reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
        }
        if ((method1 = methodCache1.find(x$1)) != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("outputIndexSize", reflParams$Cache1));
        reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        Method method2;
        MethodCache methodCache2 = (MethodCache)reflPoly$Cache2.get();
        if (methodCache2 == null) {
            methodCache2 = new EmptyMethodCache();
            reflPoly$Cache2 = new SoftReference<MethodCache>(methodCache2);
        }
        if ((method2 = methodCache2.find(x$1)) != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("outputRowCount", reflParams$Cache2));
        reflPoly$Cache2 = new SoftReference<MethodCache>(methodCache2.add(x$1, method2));
        return method2;
    }

    public Logger com$paypal$dione$spark$index$IndexManagerUtils$$logger() {
        return this.com$paypal$dione$spark$index$IndexManagerUtils$$logger;
    }

    public Seq<Seq<Tuple2<String, String>>> getMissingPartitions(String tableA, String tableB, SparkSession spark) {
        Seq<Seq<Tuple2<String, String>>> dataTablePrts = this.getTablePartitions(tableA, spark);
        Set indexTablePrts = this.getTablePartitions(tableB, spark).toSet();
        return (Seq)dataTablePrts.filterNot((Function1)new Serializable(indexTablePrts){
            public static final long serialVersionUID = 0L;
            private final Set indexTablePrts$1;

            public final boolean apply(Seq<Tuple2<String, String>> prtDef) {
                return this.indexTablePrts$1.contains(prtDef);
            }
            {
                this.indexTablePrts$1 = indexTablePrts$1;
            }
        });
    }

    public Seq<Tuple2<Map<String, String>, String>> getPartitionLocations(String tablename, Seq<Seq<Tuple2<String, String>>> partitionsSpec, SparkSession spark) {
        return (Seq)partitionsSpec.map((Function1)new Serializable(tablename, spark){
            public static final long serialVersionUID = 0L;
            private final String tablename$1;
            private final SparkSession spark$1;

            public final Tuple2<Map<String, String>, String> apply(Seq<Tuple2<String, String>> partitionSpec) {
                String staticPartitionFilter = ((TraversableOnce)partitionSpec.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> p) {
                        return new StringBuilder().append((Object)((String)p._1())).append((Object)"='").append(p._2()).append((Object)"'").toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                Row[] showPartition = (Row[])this.spark$1.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"desc formatted ", " partition (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tablename$1, staticPartitionFilter}))).collect();
                String prtLocationStr = ((Row)Predef$.MODULE$.refArrayOps((Object[])showPartition).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Row row) {
                        return row.getString(0).contains("Location");
                    }
                }).get()).getString(1);
                return new Tuple2((Object)partitionSpec.toMap(Predef$.MODULE$.$conforms()), (Object)new Path(prtLocationStr).toString());
            }
            {
                this.tablename$1 = tablename$1;
                this.spark$1 = spark$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Dataset<Row> listFilesDF(Seq<Tuple2<Map<String, String>, String>> partitionLocations, SparkSession spark) {
        List partitionLocationsRows = ((TraversableOnce)partitionLocations.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<Map<String, String>, String> a) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a._1(), a._2()}));
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
        Dataset partitionLocationsDF = spark.createDataFrame(JavaConversions$.MODULE$.seqAsJavaList((Seq)partitionLocationsRows), StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(IndexManager$.MODULE$.PARTITION_DEF_COLUMN(), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("path", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}))));
        Broadcast<SerializableConfiguration> serConf = SerializableConfiguration$.MODULE$.broadcast(spark);
        boolean isSplitChunks = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("indexer.files.chunk.split", "true"))).toBoolean();
        long chunkSize = isSplitChunks ? new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("indexer.files.chunkMB", "50"))).toLong() << 20 : Long.MAX_VALUE;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_paypal_dione_spark_index_IndexManagerUtils$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "Map"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$)}))), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Long").asType().toTypeConstructor(), $m.staticClass("scala.Long").asType().toTypeConstructor()})));
            }

            public Com_paypal_dione_spark_index_IndexManagerUtils$$typecreator4$1() {
            }
        }
        Dataset filesDF = partitionLocationsDF.repartition((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("path")})).flatMap((Function1)new Serializable(serConf, chunkSize){
            public static final long serialVersionUID = 0L;
            private final Broadcast serConf$1;
            public final long chunkSize$1;

            public final Seq<Tuple5<Map<String, String>, String, String, Object, Object>> apply(Row row) {
                Configuration conf;
                Path path = new Path((String)row.getAs("path"));
                FileSystem fs = path.getFileSystem(conf = ((SerializableConfiguration)this.serConf$1.value()).value());
                Seq fileStatuses = fs.exists(path) ? Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).toSeq() : (Seq)Seq$.MODULE$.empty();
                return (Seq)fileStatuses.flatMap((Function1)new Serializable(this, path, row){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;
                    public final Path path$1;
                    public final Row row$1;

                    public final IndexedSeq<Tuple5<Map<String, String>, String, String, Object, Object>> apply(FileStatus file) {
                        int chunks = Predef$.MODULE$.double2Double(RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.long2Long(file.getLen()).doubleValue() / Predef$.MODULE$.long2Long(this.$outer.chunkSize$1).doubleValue()))).intValue();
                        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), chunks).map((Function1)new Serializable(this, file){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$4$$anonfun$apply$1 $outer;
                            private final FileStatus file$1;

                            public final Tuple5<Map<String, String>, String, String, Object, Object> apply(int chunkId) {
                                long startPos = this.$outer.com$paypal$dione$spark$index$IndexManagerUtils$$anonfun$$anonfun$$$outer().chunkSize$1 * (long)chunkId;
                                long endPos = scala.math.package$.MODULE$.min(startPos + this.$outer.com$paypal$dione$spark$index$IndexManagerUtils$$anonfun$$anonfun$$$outer().chunkSize$1, this.file$1.getLen());
                                return new Tuple5(this.$outer.row$1.getAs(IndexManager$.MODULE$.PARTITION_DEF_COLUMN()), (Object)this.$outer.path$1.toString(), (Object)this.file$1.getPath().getName(), (Object)BoxesRunTime.boxToLong((long)startPos), (Object)BoxesRunTime.boxToLong((long)endPos));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.file$1 = file$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                    }

                    public /* synthetic */ anonfun.4 com$paypal$dione$spark$index$IndexManagerUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.path$1 = path$1;
                        this.row$1 = row$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.serConf$1 = serConf$1;
                this.chunkSize$1 = chunkSize$1;
            }
        }, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_paypal_dione_spark_index_IndexManagerUtils$$typecreator4$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{IndexManager$.MODULE$.PARTITION_DEF_COLUMN(), "path", "file", "start_position", "end_position"}));
        return filesDF;
    }

    public Dataset<Row> createIndexDF(Dataset<Row> filesDF, StructType fieldsSchema, SparkIndexer sparkIndexer) {
        StructType outputSchema = StructType$.MODULE$.apply((Seq)((TraversableLike)filesDF.schema().$plus$plus((GenTraversableOnce)fieldsSchema, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)IndexManager$.MODULE$.indexSchema(), Seq$.MODULE$.canBuildFrom()));
        ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(outputSchema);
        return filesDF.flatMap((Function1)new Serializable(fieldsSchema, sparkIndexer){
            public static final long serialVersionUID = 0L;
            private final StructType fieldsSchema$1;
            public final SparkIndexer sparkIndexer$1;

            public final Iterator<Row> apply(Row row) {
                ReaderMetrics metrics = Metrics$.MODULE$.getReaderMetricsForTask();
                String filename = new StringBuilder().append((Object)((String)row.getAs("path"))).append((Object)"/").append(row.getAs("file")).toString();
                IndexManagerUtils$.MODULE$.com$paypal$dione$spark$index$IndexManagerUtils$$logger().info(new StringBuilder().append((Object)"indexing file: ").append((Object)filename).toString());
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)row.getAs("start_position")), BoxesRunTime.unboxToLong((Object)row.getAs("end_position")));
                if (sp2 != null) {
                    Tuple2.mcJJ.sp sp3;
                    long start = sp2._1$mcJ$sp();
                    long end = sp2._2$mcJ$sp();
                    Tuple2.mcJJ.sp sp4 = sp3 = new Tuple2.mcJJ.sp(start, end);
                    long start2 = sp4._1$mcJ$sp();
                    long end2 = sp4._2$mcJ$sp();
                    return this.sparkIndexer$1.initHdfsIndexer(new Path(filename), new Configuration(), start2, end2, this.fieldsSchema$1).iteratorWithMetadata().map((Function1)new Serializable(this, metrics, row){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.createIndexDF.1 $outer;
                        private final ReaderMetrics metrics$1;
                        private final Row row$2;

                        public final Row apply(Tuple2<Object, HdfsIndexerMetadata> t) {
                            this.metrics$1.incBytes(((HdfsIndexerMetadata)t._2()).size());
                            return Row$.MODULE$.fromSeq((Seq)((TraversableLike)this.row$2.toSeq().$plus$plus(this.$outer.sparkIndexer$1.convert(t._1()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((HdfsIndexerMetadata)t._2()).file(), BoxesRunTime.boxToLong((long)((HdfsIndexerMetadata)t._2()).position()), BoxesRunTime.boxToInteger((int)((HdfsIndexerMetadata)t._2()).numInBlock()), BoxesRunTime.boxToInteger((int)((HdfsIndexerMetadata)t._2()).size())})), Seq$.MODULE$.canBuildFrom()));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.metrics$1 = metrics$1;
                            this.row$2 = row$2;
                        }
                    });
                }
                throw new MatchError((Object)sp2);
            }
            {
                this.fieldsSchema$1 = fieldsSchema$1;
                this.sparkIndexer$1 = sparkIndexer$1;
            }
        }, (Encoder)encoder);
    }

    public Tuple3<Object, Object, Object> calcBtreeProperties(Dataset<Row> filesDF, int partitionsSpecLength, Function1<Dataset<Row>, Dataset<Row>> indexer) {
        SparkSession spark = filesDF.sparkSession();
        int indexInterval = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("index.manager.btree.interval", "1000"))).toInt();
        int userHeight = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("index.manager.btree.height", "-1"))).toInt();
        int userNumParts = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("index.manager.btree.num.parts", "-1"))).toInt();
        if (userHeight > 0 && userNumParts > 0) {
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)userNumParts), (Object)BoxesRunTime.boxToInteger((int)indexInterval), (Object)BoxesRunTime.boxToInteger((int)userHeight));
        }
        double sampleRate = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("indexer.sampler.files.rate", "0.05"))).toDouble();
        Tuple2<Object, Object> tuple2 = this.sampleFilesAndInferSize((Dataset<Row>)filesDF.drop(IndexManager$.MODULE$.PARTITION_DEF_COLUMN()), sampleRate, indexer);
        if (tuple2 != null) {
            Tuple2.mcIJ.sp sp2;
            int estimatedPartsTotal = tuple2._1$mcI$sp();
            long estimatedRowsTotal = tuple2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp3 = sp2 = new Tuple2.mcIJ.sp(estimatedPartsTotal, estimatedRowsTotal);
            int estimatedPartsTotal2 = sp3._1$mcI$sp();
            long estimatedRowsTotal2 = sp3._2$mcJ$sp();
            int estimatedParts = Predef$.MODULE$.double2Double(RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.int2Integer(estimatedPartsTotal2).doubleValue() / (double)partitionsSpecLength))).intValue();
            int estimatedRows = Predef$.MODULE$.double2Double(RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.long2Long(estimatedRowsTotal2).doubleValue() / (double)partitionsSpecLength))).intValue();
            Predef$.MODULE$.require(estimatedParts > 0);
            Predef$.MODULE$.require(estimatedRows > 0);
            int height2 = userHeight <= 0 ? Predef$.MODULE$.double2Double(RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(scala.math.package$.MODULE$.log((double)estimatedRows) / scala.math.package$.MODULE$.log((double)indexInterval)))).intValue() : userHeight;
            int numParts = userNumParts > 0 ? userNumParts : estimatedParts;
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)numParts), (Object)BoxesRunTime.boxToInteger((int)indexInterval), (Object)BoxesRunTime.boxToInteger((int)height2));
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Object> sampleFilesAndInferSize(Dataset<Row> filesDF, double sampleRate, Function1<Dataset<Row>, Dataset<Row>> indexer) {
        SparkSession spark = filesDF.sparkSession();
        Dataset sampleFiles = filesDF.sample(sampleRate);
        int reduceShufflePartitions = Predef$.MODULE$.double2Double(RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("spark.sql.shuffle.partitions"))).toDouble() * sampleRate))).intValue();
        Dataset sampleIndexDF = ((Dataset)indexer.apply((Object)sampleFiles)).repartition(reduceShufflePartitions);
        Tuple2<Object, Object> tuple2 = this.inferSize((Dataset<Row>)sampleIndexDF);
        if (tuple2 != null) {
            Tuple2.mcIJ.sp sp2;
            int numPartsSample = tuple2._1$mcI$sp();
            long rowCountSample = tuple2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp3 = sp2 = new Tuple2.mcIJ.sp(numPartsSample, rowCountSample);
            int numPartsSample2 = sp3._1$mcI$sp();
            long rowCountSample2 = sp3._2$mcJ$sp();
            int estimatedParts = Predef$.MODULE$.double2Double(RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.int2Integer(numPartsSample2).doubleValue() / sampleRate))).intValue();
            long estimatedRows = Predef$.MODULE$.double2Double(RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.long2Long(rowCountSample2).doubleValue() / sampleRate))).longValue();
            this.com$paypal$dione$spark$index$IndexManagerUtils$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"estimatedParts: ", ", estimatedRows: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)estimatedParts), BoxesRunTime.boxToLong((long)estimatedRows)})));
            return new Tuple2.mcIJ.sp(estimatedParts, estimatedRows);
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Tuple2<Object, Object> inferSize(Dataset<Row> indexDF) {
        spark = indexDF.sparkSession();
        fs = FileSystem.get((Configuration)spark.sparkContext().hadoopConfiguration());
        tmpPath = new StringBuilder().append((Object)"/tmp/").append((Object)UUID.randomUUID().toString()).toString();
        codec = spark.conf().getOption("spark.sql.avro.compression.codec");
        spark.conf().set("spark.sql.avro.compression.codec", "deflate");
        com.databricks.spark.avro.package$.MODULE$.AvroDataFrameWriter(indexDF.write()).avro().apply((Object)tmpPath);
        codec.foreach((Function1)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$2;

            public final void apply(String x$4) {
                this.spark$2.conf().set("spark.sql.avro.compression.codec", x$4);
            }
            {
                this.spark$2 = spark$2;
            }
        });
        sample = new Object(spark, fs, tmpPath){
            private final /* synthetic */ Tuple2 x$5;
            private final long inputSourceBytes;
            private final long outputRowCount;
            private final double outputIndexSize;

            public long inputSourceBytes() {
                return this.inputSourceBytes;
            }

            public long outputRowCount() {
                return this.outputRowCount;
            }

            public double outputIndexSize() {
                return this.outputIndexSize;
            }
            {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(anon.1.class.getClassLoader());
                public final class anon$1$$typecreator8$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Long").asType().toTypeConstructor(), $m.staticClass("scala.Long").asType().toTypeConstructor()})));
                    }

                    public anon$1$$typecreator8$1(anon.1 $outer) {
                    }
                }
                Tuple2 tuple2 = (Tuple2)((Dataset)com.databricks.spark.avro.package$.MODULE$.AvroDataFrameReader(spark$2.read()).avro().apply((Object)tmpPath$1)).agg(functions$.MODULE$.sum("data_size"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)))})).as(spark$2.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new anon$1$$typecreator8$1(this)))).head();
                if (tuple2 != null) {
                    long inputSourceBytes = tuple2._1$mcJ$sp();
                    long outputRowCount = tuple2._2$mcJ$sp();
                    Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(inputSourceBytes, outputRowCount);
                    this.x$5 = sp2;
                    this.inputSourceBytes = this.x$5._1$mcJ$sp();
                    this.outputRowCount = this.x$5._2$mcJ$sp();
                    this.outputIndexSize = Predef$.MODULE$.long2Long(IndexManagerUtils$.MODULE$.com$paypal$dione$spark$index$IndexManagerUtils$$getPathSize$1(new Path(tmpPath$1), fs$1)).doubleValue();
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
        };
        targetFileSize = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("index.manager.targetFileSizeMB", "50"))).toInt() << 20;
        qual1 = sample;
        numOutputFiles = Predef$.MODULE$.double2Double(RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble((Object)((Double)IndexManagerUtils$.reflMethod$Method1(qual1.getClass()).invoke(qual1, new Object[0]))) / (double)targetFileSize))).intValue();
        qual2 = sample;
        ** GOTO lbl22
        {
            catch (Throwable var6_13) {
                var3_3.delete(new Path((String)var4_4), true);
                throw var6_13;
            }
lbl22:
            // 2 sources

            v0 = new Tuple2.mcIJ.sp(numOutputFiles, BoxesRunTime.unboxToLong((Object)((Long)IndexManagerUtils$.reflMethod$Method2(qual2.getClass()).invoke(qual2, new Object[0]))));
            {
                catch (InvocationTargetException var13_12) {
                    throw var13_12.getCause();
                }
                fs.delete(new Path(tmpPath), true);
                return v0;
                catch (InvocationTargetException var11_11) {}
                throw var11_11.getCause();
            }
        }
    }

    public Dataset<Row> initNewIndexTable(SparkSession spark, IndexSpec indexSpec) {
        IndexSpec indexSpec2 = indexSpec;
        if (indexSpec2 != null) {
            String string;
            Tuple4 tuple4;
            String dataTableName = indexSpec2.dataTableName();
            String indexTableName = indexSpec2.indexTableName();
            Seq<String> keys = indexSpec2.keys();
            Seq<String> moreFields = indexSpec2.moreFields();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)dataTableName, (Object)indexTableName, keys, moreFields);
            String dataTableName2 = (String)tuple42._1();
            String indexTableName2 = (String)tuple42._2();
            Seq keys2 = (Seq)tuple42._3();
            Seq moreFields2 = (Seq)tuple42._4();
            Seq cols = (Seq)keys2.$plus$plus((GenTraversableOnce)moreFields2, Seq$.MODULE$.canBuildFrom());
            Dataset df = spark.table(dataTableName2).select((String)cols.head(), (Seq)cols.tail());
            StructType colsSchema = this.toSafeDataFrame((Dataset<Row>)df).schema();
            String schemaStr = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructType[]{colsSchema, IndexManager$.MODULE$.indexSchema()}))).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<String> apply(StructType schema) {
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(StructField field) {
                            return new StringBuilder().append((Object)field.name()).append((Object)" ").append((Object)field.dataType().typeName()).toString();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
            Seq tblproperties = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.meta.dataTableName"), (Object)dataTableName2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.meta.keys"), (Object)keys2.mkString("|")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.meta.moreFields"), (Object)moreFields2.mkString("|"))}))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> t) {
                    return new StringBuilder().append((Object)"'").append(t._1()).append((Object)"'='").append(t._2()).append((Object)"'").toString();
                }
            }, Seq$.MODULE$.canBuildFrom());
            String[] partitionsKeys = (String[])Predef$.MODULE$.refArrayOps((Object[])spark.catalog().listColumns(dataTableName2).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(org.apache.spark.sql.catalog.Column x$7) {
                    return x$7.isPartition();
                }
            }).collect()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(org.apache.spark.sql.catalog.Column x$8) {
                    return x$8.name();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            if (Predef$.MODULE$.refArrayOps((Object[])partitionsKeys).nonEmpty()) {
                StructType partitionsSchema = spark.table(dataTableName2).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionsKeys).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Column apply(String colName) {
                        return functions$.MODULE$.col(colName);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).schema();
                String partitionsSchemaStr = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionsSchema.fields()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StructField field) {
                        return new StringBuilder().append((Object)field.name()).append((Object)" ").append((Object)field.dataType().typeName()).toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
                string = new StringBuilder().append((Object)" partitioned by (").append((Object)partitionsSchemaStr).append((Object)") ").toString();
            } else {
                string = "";
            }
            String partitionedStr = string;
            return spark.sql(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create table ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexTableName2, schemaStr}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " stored as avro TBLPROPERTIES (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionedStr, tblproperties.mkString(",")}))).toString());
        }
        throw new MatchError((Object)indexSpec2);
    }

    public Seq<Seq<Tuple2<String, String>>> getTablePartitions(String tableName, SparkSession spark) {
        return this.getTablePartitions(tableName, (Dataset<Row>)spark.table(tableName), spark);
    }

    public Seq<Seq<Tuple2<String, String>>> getTablePartitions(String keysTableName, Dataset<Row> valuesDF, SparkSession spark) {
        String[] partitionKeys = (String[])Predef$.MODULE$.refArrayOps((Object[])spark.catalog().listColumns(keysTableName).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(org.apache.spark.sql.catalog.Column x$9) {
                return x$9.isPartition();
            }
        }).collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(org.apache.spark.sql.catalog.Column x$10) {
                return x$10.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Dataset partitionValues = valuesDF.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])partitionKeys)).distinct();
        Map[] valuesMap = (Map[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionValues.collect()).map((Function1)new Serializable(partitionKeys){
            public static final long serialVersionUID = 0L;
            private final String[] partitionKeys$1;

            public final Map<String, Object> apply(Row x$11) {
                return x$11.getValuesMap((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.partitionKeys$1));
            }
            {
                this.partitionKeys$1 = partitionKeys$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)))).distinct();
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])valuesMap).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, String>> apply(Map<String, Object> x$12) {
                return x$12.mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$13) {
                        return x$13.toString();
                    }
                }).toSeq();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).toSeq();
    }

    public Dataset<Row> toSafeDataFrame(Dataset<Row> df) {
        Seq decimalCols = (Seq)df.schema().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField col) {
                DataType dataType = col.dataType();
                boolean bl = DecimalType$.MODULE$.unapply(dataType);
                return bl;
            }
        });
        boolean castDecimal = new StringOps(Predef$.MODULE$.augmentString(df.sparkSession().conf().get("indexer.castDecimalToDouble", "false"))).toBoolean();
        if (decimalCols.nonEmpty() && !castDecimal) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decimal columns are not supported. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"set indexer.castDecimalToDouble=true to index the columns as double type"})).s((Seq)Nil$.MODULE$)).toString());
        }
        this.com$paypal$dione$spark$index$IndexManagerUtils$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Converting column(s) to double: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)decimalCols.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$14) {
                return x$14.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        Dataset safeDF = (Dataset)decimalCols.foldLeft(df, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Dataset<Row> apply(Dataset<Row> x0$1, StructField x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    Dataset df = (Dataset)tuple2._1();
                    StructField field = (StructField)tuple2._2();
                    Dataset dataset = df.withColumn(field.name(), functions$.MODULE$.col(field.name()).cast("double"));
                    return dataset;
                }
                throw new MatchError((Object)tuple2);
            }
        });
        return safeDF;
    }

    public IndexManager createIndexManager(SparkSession spark, IndexSpec indexSpec) {
        Tuple2<String, String> tuple2 = this.getTableName(spark, indexSpec.dataTableName());
        if (tuple2 != null) {
            String serde;
            Tuple2 tuple22;
            String dataDb = (String)tuple2._1();
            String dataTable = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataDb, (Object)dataTable);
            String dataDb2 = (String)tuple23._1();
            String dataTable2 = (String)tuple23._2();
            CatalogStorageFormat storage = spark.sessionState().catalog().externalCatalog().getTable(dataDb2, dataTable2).storage();
            String format = (String)storage.inputFormat().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new RuntimeException("cannot determine data input format");
                }
            });
            Tuple2 tuple24 = new Tuple2((Object)format, (Object)(serde = (String)storage.serde().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new RuntimeException("cannot determine data serde");
                }
            })));
            if (tuple24 != null) {
                Tuple3 tuple3;
                String inputFormat = (String)tuple24._1();
                String serde2 = (String)tuple24._2();
                Tuple3 tuple32 = tuple3 = new Tuple3((Object)tuple24, (Object)inputFormat, (Object)serde2);
                Tuple2 storage2 = (Tuple2)tuple32._1();
                String inputFormat2 = (String)tuple32._2();
                String serde3 = (String)tuple32._3();
                SparkIndexer sparkIndexer = ((IndexManagerFactory)((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IndexManagerFactory[]{SeqFileSparkIndexer$.MODULE$, AvroSparkIndexer$.MODULE$, ParquetSparkIndexer$.MODULE$, OrcSparkIndexer$.MODULE$}))).find((Function1)new Serializable(inputFormat2, serde3){
                    public static final long serialVersionUID = 0L;
                    private final String inputFormat$1;
                    private final String serde$1;

                    public final boolean apply(IndexManagerFactory x$17) {
                        return x$17.canResolve(this.inputFormat$1, this.serde$1);
                    }
                    {
                        this.inputFormat$1 = inputFormat$1;
                        this.serde$1 = serde$1;
                    }
                }).getOrElse((Function0)new Serializable(storage2){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 storage$1;

                    public final Nothing$ apply() {
                        throw new RuntimeException(new StringBuilder().append((Object)"could not find indexer for data type: ").append((Object)this.storage$1).toString());
                    }
                    {
                        this.storage$1 = storage$1;
                    }
                })).createSparkIndexer(spark, indexSpec);
                this.com$paypal$dione$spark$index$IndexManagerUtils$$logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initialized new IndexManager for table ", " with storage ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataTable2, storage2}))).append((Object)sparkIndexer.getClass().getName()).toString());
                return new IndexManager(spark, sparkIndexer, indexSpec);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<String, String> getTableName(SparkSession spark, String tableName) {
        List list;
        block6: {
            Tuple2 tuple2;
            block5: {
                .colon.colon colon2;
                boolean bl;
                block4: {
                    bl = false;
                    colon2 = null;
                    list = Predef$.MODULE$.refArrayOps((Object[])tableName.split("\\.")).toList();
                    if (!(list instanceof .colon.colon)) break block4;
                    bl = true;
                    colon2 = (.colon.colon)list;
                    String table = (String)colon2.head();
                    List list2 = colon2.tl$1();
                    if (!Nil$.MODULE$.equals(list2)) break block4;
                    tuple2 = new Tuple2((Object)spark.catalog().currentDatabase(), (Object)table);
                    break block5;
                }
                if (!bl) break block6;
                String db = (String)colon2.head();
                List list3 = colon2.tl$1();
                if (!(list3 instanceof .colon.colon)) break block6;
                .colon.colon colon3 = (.colon.colon)list3;
                String table = (String)colon3.head();
                List list4 = colon3.tl$1();
                if (!Nil$.MODULE$.equals(list4)) break block6;
                tuple2 = new Tuple2((Object)db, (Object)table);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                String db = (String)tuple22._1();
                String table = (String)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)db, (Object)table);
                String db2 = (String)tuple24._1();
                String table2 = (String)tuple24._2();
                return new Tuple2((Object)db2, (Object)table2);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"invalid table name: ").append((Object)list).toString());
    }

    public CatalogTable getSparkCatalogTable(SparkSession spark, String fullTableName) {
        Tuple2<String, String> tuple2 = this.getTableName(spark, fullTableName);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String db = (String)tuple2._1();
            String table = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)db, (Object)table);
            String db2 = (String)tuple23._1();
            String table2 = (String)tuple23._2();
            TableIdentifier identifier = new TableIdentifier(table2, (Option)new Some((Object)db2));
            CatalogTable sparkCatalogTable = spark.sessionState().catalog().getTableMetadata(identifier);
            return sparkCatalogTable;
        }
        throw new MatchError(tuple2);
    }

    public final long com$paypal$dione$spark$index$IndexManagerUtils$$getPathSize$1(Path path, FileSystem fs$1) {
        return fs$1.getContentSummary(path).getSpaceConsumed() / (long)fs$1.getDefaultReplication(path);
    }

    private IndexManagerUtils$() {
        MODULE$ = this;
        this.com$paypal$dione$spark$index$IndexManagerUtils$$logger = LoggerFactory.getLogger(this.getClass());
    }
}

