/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.time;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class UtcTimestamp {
    private UtcTimestamp() {
    }

    public static OffsetDateTime now() {
        return UtcTimestamp.utc(Instant.now());
    }

    public static OffsetDateTime now(Clock clock) {
        return UtcTimestamp.utc(clock.instant());
    }

    public static OffsetDateTime utc(Instant instant) {
        LocalDateTime utcDateTime = LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), ZoneOffset.UTC);
        return OffsetDateTime.of(utcDateTime, ZoneOffset.UTC);
    }
}

