/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricSet;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public interface TaggedMetricRegistry
extends TaggedMetricSet {
    public Timer timer(MetricName var1);

    public Timer timer(MetricName var1, Supplier<Timer> var2);

    public Meter meter(MetricName var1);

    public Meter meter(MetricName var1, Supplier<Meter> var2);

    public Histogram histogram(MetricName var1);

    public Histogram histogram(MetricName var1, Supplier<Histogram> var2);

    default public <T> Optional<Gauge<T>> gauge(MetricName metricName) {
        Metric metric = this.getMetrics().get(metricName);
        if (metric instanceof Gauge) {
            return Optional.of((Gauge)metric);
        }
        return Optional.empty();
    }

    public <T> Gauge<T> gauge(MetricName var1, Gauge<T> var2);

    default public void registerWithReplacement(MetricName metricName, Gauge<?> gauge) {
        Gauge<?> existing = this.gauge(metricName, gauge);
        if (existing == gauge) {
            return;
        }
        this.remove(metricName).ifPresent(_removed -> LoggerFactory.getLogger(this.getClass()).debug("Removed previously registered gauge {}", (Object)SafeArg.of((String)"metricName", (Object)metricName)));
        this.gauge(metricName, gauge);
    }

    public Counter counter(MetricName var1);

    public Counter counter(MetricName var1, Supplier<Counter> var2);

    public Optional<Metric> remove(MetricName var1);

    public void addMetrics(@Safe String var1, @Safe String var2, TaggedMetricSet var3);

    public Optional<TaggedMetricSet> removeMetrics(@Safe String var1, @Safe String var2);

    public boolean removeMetrics(@Safe String var1, @Safe String var2, TaggedMetricSet var3);
}

