/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.RealMetricName;
import com.palantir.tritium.metrics.registry.TagMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

final class ImmutableMetricName {
    private ImmutableMetricName() {
    }

    public static abstract class Builder {
        private @Nullable String safeName;
        private TagMap tagMap = TagMap.EMPTY;

        @CanIgnoreReturnValue
        public MetricName.Builder from(MetricName instance) {
            Preconditions.checkNotNull((Object)instance, (String)"instance");
            this.safeName(instance.safeName());
            this.putAllSafeTags(instance.safeTags());
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder safeName(@Safe String value) {
            this.safeName = (String)Preconditions.checkNotNull((Object)value, (String)"safeName");
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder putSafeTags(@Safe String key, @Safe String value) {
            Preconditions.checkNotNull((Object)key, (String)"safeTagName");
            Preconditions.checkNotNull((Object)value, (String)"safeTagValue");
            this.tagMap = this.tagMap.withEntry(key, value);
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder putSafeTags(@Safe @Safe Map.Entry<@Safe String, @Safe ? extends String> entry) {
            Preconditions.checkNotNull(entry, (String)"entry");
            this.tagMap = this.tagMap.withEntry(entry.getKey(), entry.getValue());
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder safeTags(@Safe @Safe Map<@Safe String, @Safe ? extends String> entries) {
            Preconditions.checkNotNull(entries, (String)"entries");
            this.tagMap = TagMap.of(entries);
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder putAllSafeTags(@Safe @Safe Map<@Safe String, @Safe ? extends String> entries) {
            Preconditions.checkNotNull(entries, (String)"entries");
            if (!entries.isEmpty()) {
                this.tagMap = this.tagMap.isEmpty() ? TagMap.of(entries) : TagMap.of((Map<String, String>)ImmutableMap.builderWithExpectedSize((int)(this.tagMap.size() + entries.size())).putAll((Map)this.tagMap).putAll(entries).buildKeepingLast());
            }
            return (MetricName.Builder)this;
        }

        public MetricName build() {
            return new RealMetricName(this.safeName, this.tagMap);
        }
    }
}

