/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.tritium.metrics.registry.ExemplarMetadataProvider;
import com.palantir.tritium.metrics.registry.WeightedSnapshotWithExemplars;
import java.time.Duration;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;

public final class LockFreeExponentiallyDecayingReservoirWithExemplars
implements Reservoir {
    private static final double SECONDS_PER_NANO = 1.0E-9;
    private static final AtomicReferenceFieldUpdater<LockFreeExponentiallyDecayingReservoirWithExemplars, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(LockFreeExponentiallyDecayingReservoirWithExemplars.class, State.class, "state");
    private final int size;
    private final long rescaleThresholdNanos;
    private final Clock clock;
    private volatile State state;

    private LockFreeExponentiallyDecayingReservoirWithExemplars(int size, double alpha, Duration rescaleThreshold, Clock clock, ExemplarMetadataProvider<?> exemplarMetadataProvider) {
        double alphaNanos = alpha * 1.0E-9;
        this.size = size;
        this.clock = clock;
        this.rescaleThresholdNanos = rescaleThreshold.toNanos();
        this.state = new State(alphaNanos, size, clock.getTick(), 0, new ConcurrentSkipListMap<Double, WeightedSnapshotWithExemplars.WeightedSampleWithExemplar>(), exemplarMetadataProvider);
    }

    public int size() {
        return Math.min(this.size, this.state.count);
    }

    public void update(long value) {
        long now = this.clock.getTick();
        this.rescaleIfNeeded(now).update(value, now);
    }

    private State rescaleIfNeeded(long currentTick) {
        State stateSnapshot = this.state;
        if (currentTick - stateSnapshot.startTick >= this.rescaleThresholdNanos) {
            return this.doRescale(currentTick, stateSnapshot);
        }
        return stateSnapshot;
    }

    private State doRescale(long currentTick, State stateSnapshot) {
        State newState = stateSnapshot.rescale(currentTick);
        if (stateUpdater.compareAndSet(this, stateSnapshot, newState)) {
            return newState;
        }
        return this.state;
    }

    public Snapshot getSnapshot() {
        State stateSnapshot = this.rescaleIfNeeded(this.clock.getTick());
        return WeightedSnapshotWithExemplars.snapshot(stateSnapshot.exemplarMetadataProvider, stateSnapshot.values.values());
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class State {
        private static final AtomicIntegerFieldUpdater<State> countUpdater = AtomicIntegerFieldUpdater.newUpdater(State.class, "count");
        private final double alphaNanos;
        private final int size;
        private final long startTick;
        private final ConcurrentSkipListMap<Double, WeightedSnapshotWithExemplars.WeightedSampleWithExemplar> values;
        private volatile int count;
        private final ExemplarMetadataProvider<?> exemplarMetadataProvider;

        State(double alphaNanos, int size, long startTick, int count, ConcurrentSkipListMap<Double, WeightedSnapshotWithExemplars.WeightedSampleWithExemplar> values, ExemplarMetadataProvider<?> exemplarMetadataProvider) {
            this.alphaNanos = alphaNanos;
            this.size = size;
            this.startTick = startTick;
            this.values = values;
            this.count = count;
            this.exemplarMetadataProvider = exemplarMetadataProvider;
        }

        private void update(long value, long timestampNanos) {
            boolean mapIsFull;
            double itemWeight = this.weight(timestampNanos - this.startTick);
            double priority = itemWeight / ThreadLocalRandom.current().nextDouble();
            boolean bl = mapIsFull = this.count >= this.size;
            if (!mapIsFull || this.values.firstKey() < priority) {
                this.addSample(priority, value, itemWeight, mapIsFull, this.exemplarMetadataProvider.collect());
            }
        }

        private void addSample(double priority, long value, double itemWeight, boolean bypassIncrement, @Nullable Object exemplarMetadata) {
            if (this.values.putIfAbsent(priority, new WeightedSnapshotWithExemplars.WeightedSampleWithExemplar(value, itemWeight, exemplarMetadata)) == null && (bypassIncrement || countUpdater.incrementAndGet(this) > this.size)) {
                this.values.pollFirstEntry();
            }
        }

        State rescale(long newTick) {
            long durationNanos = newTick - this.startTick;
            double scalingFactor = Math.exp(-this.alphaNanos * (double)durationNanos);
            int newCount = 0;
            ConcurrentSkipListMap<Double, WeightedSnapshotWithExemplars.WeightedSampleWithExemplar> newValues = new ConcurrentSkipListMap<Double, WeightedSnapshotWithExemplars.WeightedSampleWithExemplar>();
            if (Double.compare(scalingFactor, 0.0) != 0) {
                RescalingConsumer consumer = new RescalingConsumer(scalingFactor, newValues);
                this.values.forEach(consumer);
                newCount = consumer.count;
            }
            while (newCount > this.size) {
                Preconditions.checkNotNull(newValues.pollFirstEntry(), (String)"Expected an entry");
                --newCount;
            }
            return new State(this.alphaNanos, this.size, newTick, newCount, newValues, this.exemplarMetadataProvider);
        }

        private double weight(long durationNanos) {
            return Math.exp(this.alphaNanos * (double)durationNanos);
        }
    }

    public static final class Builder {
        private static final int DEFAULT_SIZE = 1028;
        private static final double DEFAULT_ALPHA = 0.015;
        private static final Duration DEFAULT_RESCALE_THRESHOLD = Duration.ofHours(1L);
        private int size = 1028;
        private double alpha = 0.015;
        private Duration rescaleThreshold = DEFAULT_RESCALE_THRESHOLD;
        private Clock clock = Clock.defaultClock();
        private ExemplarMetadataProvider<?> exemplarMetadataProvider = () -> null;

        private Builder() {
        }

        public Builder exemplarProvider(ExemplarMetadataProvider<?> value) {
            this.exemplarMetadataProvider = (ExemplarMetadataProvider)Preconditions.checkNotNull(value, (String)"exemplarMetadataProvider is required");
            return this;
        }

        public Builder size(int value) {
            if (value <= 0) {
                throw new SafeIllegalArgumentException("LockFreeExponentiallyDecayingReservoirWithExemplars size must be positive", new Arg[]{SafeArg.of((String)"size", (Object)value)});
            }
            this.size = value;
            return this;
        }

        public Builder alpha(double value) {
            this.alpha = value;
            return this;
        }

        public Builder rescaleThreshold(Duration value) {
            this.rescaleThreshold = (Duration)Preconditions.checkNotNull((Object)value, (String)"rescaleThreshold is required");
            return this;
        }

        public Builder clock(Clock value) {
            this.clock = (Clock)Preconditions.checkNotNull((Object)value, (String)"clock is required");
            return this;
        }

        public Reservoir build() {
            return new LockFreeExponentiallyDecayingReservoirWithExemplars(this.size, this.alpha, this.rescaleThreshold, this.clock, this.exemplarMetadataProvider);
        }
    }

    private static final class RescalingConsumer
    implements BiConsumer<Double, WeightedSnapshotWithExemplars.WeightedSampleWithExemplar> {
        private final double scalingFactor;
        private final ConcurrentSkipListMap<Double, WeightedSnapshotWithExemplars.WeightedSampleWithExemplar> values;
        private int count;

        RescalingConsumer(double scalingFactor, ConcurrentSkipListMap<Double, WeightedSnapshotWithExemplars.WeightedSampleWithExemplar> values) {
            this.scalingFactor = scalingFactor;
            this.values = values;
        }

        @Override
        public void accept(Double priority, WeightedSnapshotWithExemplars.WeightedSampleWithExemplar sample) {
            double newWeight = sample.weight() * this.scalingFactor;
            if (Double.compare(newWeight, 0.0) == 0) {
                return;
            }
            WeightedSnapshotWithExemplars.WeightedSampleWithExemplar newSample = new WeightedSnapshotWithExemplars.WeightedSampleWithExemplar(sample.value(), newWeight, sample.exemplarMetadata());
            if (this.values.put(priority * this.scalingFactor, newSample) == null) {
                ++this.count;
            }
        }
    }
}

