/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.WeightedSnapshot;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.DefaultLongExemplar;
import com.palantir.tritium.metrics.registry.ExemplarMetadataProvider;
import com.palantir.tritium.metrics.registry.ExemplarsCapture;
import com.palantir.tritium.metrics.registry.LongExemplar;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;

final class WeightedSnapshotWithExemplars
extends Snapshot
implements ExemplarsCapture {
    private final WeightedSnapshot weightedSnapshot;
    private final ExemplarMetadataProvider<?> exemplarProvider;
    private final List<LongExemplar<Object>> exemplars;

    private WeightedSnapshotWithExemplars(ExemplarMetadataProvider<?> provider, List<LongExemplar<Object>> exemplars, WeightedSnapshot snapshot) {
        this.exemplars = Collections.unmodifiableList(exemplars);
        this.weightedSnapshot = (WeightedSnapshot)Preconditions.checkNotNull((Object)snapshot, (String)"snapshot");
        this.exemplarProvider = (ExemplarMetadataProvider)Preconditions.checkNotNull(provider, (String)"provider");
    }

    static Snapshot snapshot(ExemplarMetadataProvider<?> provider, Collection<WeightedSampleWithExemplar> values) {
        ArrayList weightedSamples = new ArrayList(values.size());
        ArrayList<LongExemplar<Object>> exemplars = new ArrayList<LongExemplar<Object>>();
        values.forEach(v -> {
            weightedSamples.add(new WeightedSnapshot.WeightedSample(v.value, v.weight));
            if (v.exemplarMetadata != null) {
                exemplars.add(DefaultLongExemplar.of(v.exemplarMetadata, v.value));
            }
        });
        WeightedSnapshot weightedSnapshot = new WeightedSnapshot(weightedSamples);
        if (exemplars.isEmpty()) {
            return weightedSnapshot;
        }
        return new WeightedSnapshotWithExemplars(provider, exemplars, weightedSnapshot);
    }

    public <U> List<LongExemplar<U>> getSamples(ExemplarMetadataProvider<U> provider) {
        if (this.exemplarProvider == provider) {
            return this.exemplars;
        }
        return List.of();
    }

    public double getValue(double quantile) {
        return this.weightedSnapshot.getValue(quantile);
    }

    public long[] getValues() {
        return this.weightedSnapshot.getValues();
    }

    public int size() {
        return this.weightedSnapshot.size();
    }

    public long getMax() {
        return this.weightedSnapshot.getMax();
    }

    public double getMean() {
        return this.weightedSnapshot.getMean();
    }

    public long getMin() {
        return this.weightedSnapshot.getMin();
    }

    public double getStdDev() {
        return this.weightedSnapshot.getStdDev();
    }

    public void dump(OutputStream output) {
        this.weightedSnapshot.dump(output);
    }

    static class WeightedSampleWithExemplar {
        private final long value;
        private final double weight;
        private final @Nullable Object exemplarMetadata;

        WeightedSampleWithExemplar(long value, double weight, @Nullable Object exemplarMetadata) {
            this.value = value;
            this.weight = weight;
            this.exemplarMetadata = exemplarMetadata;
        }

        long value() {
            return this.value;
        }

        double weight() {
            return this.weight;
        }

        @Nullable Object exemplarMetadata() {
            return this.exemplarMetadata;
        }
    }
}

