/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.google.common.collect.ImmutableSortedMap;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TagMap;
import java.util.Map;
import java.util.SortedMap;
import org.jspecify.annotations.Nullable;

final class RealMetricName
implements MetricName {
    private final String safeName;
    private final TagMap safeTags;
    private int hashCode;

    RealMetricName(String safeName, TagMap safeTags) {
        this.safeName = (String)Preconditions.checkNotNull((Object)safeName, (String)"safeName is required");
        this.safeTags = (TagMap)Preconditions.checkNotNull((Object)safeTags, (String)"safeTags is required");
    }

    private int computeHashCode() {
        int hash = 5381;
        hash += (hash << 5) + this.safeName().hashCode();
        hash += (hash << 5) + this.safeTags().hashCode();
        return hash;
    }

    @Override
    public String safeName() {
        return this.safeName;
    }

    public TagMap safeTags() {
        return this.safeTags;
    }

    public String toString() {
        return "MetricName{safeName=" + this.safeName + ", safeTags=" + String.valueOf(this.safeTags) + "}";
    }

    public int hashCode() {
        int memoized = this.hashCode;
        if (memoized == 0) {
            this.hashCode = memoized = this.computeHashCode();
        }
        return memoized;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof MetricName)) {
            return false;
        }
        MetricName otherMetric = (MetricName)other;
        if (this == other) {
            return true;
        }
        return this.safeName().equals(otherMetric.safeName()) && this.safeTags().equals(otherMetric.safeTags());
    }

    static MetricName create(String safeName) {
        return new RealMetricName(safeName, TagMap.EMPTY);
    }

    static MetricName create(MetricName other) {
        return new RealMetricName(other.safeName(), TagMap.of(other.safeTags()));
    }

    static MetricName create(MetricName other, String extraTagName, String extraTagValue) {
        return new RealMetricName(other.safeName(), RealMetricName.withEntry(other.safeTags(), extraTagName, extraTagValue));
    }

    private static TagMap withEntry(SortedMap<String, String> tags, String extraTagName, String extraTagValue) {
        if (tags instanceof TagMap) {
            TagMap tagMap = (TagMap)tags;
            return tagMap.withEntry(extraTagName, extraTagValue);
        }
        return RealMetricName.withEntryFallback(tags, extraTagName, extraTagValue);
    }

    private static TagMap withEntryFallback(SortedMap<String, String> tags, String extraTagName, String extraTagValue) {
        return TagMap.of((Map<String, String>)ImmutableSortedMap.naturalOrder().putAll(tags).put((Object)extraTagName, (Object)extraTagValue).buildOrThrow());
    }
}

