/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.google.common.annotations.VisibleForTesting;
import com.palantir.logsafe.Preconditions;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Recorder;
import org.jspecify.annotations.NonNull;
import org.mpierce.metrics.reservoir.hdrhistogram.HdrHistogramReservoir;

final class Reservoirs {
    private Reservoirs() {
        throw new UnsupportedOperationException();
    }

    static @NonNull Reservoir hdrHistogramReservoir() {
        return Reservoirs.hdrHistogramReservoir(new Recorder(2));
    }

    private static @NonNull Reservoir hdrHistogramReservoir(Recorder recorder) {
        Preconditions.checkNotNull((Object)recorder, (String)"recorder");
        return new HdrHistogramReservoir(recorder);
    }

    static @NonNull Reservoir slidingTimeWindowArrayReservoir(long window, TimeUnit windowUnit) {
        return Reservoirs.slidingTimeWindowArrayReservoir(window, windowUnit, Clock.defaultClock());
    }

    @VisibleForTesting
    static @NonNull Reservoir slidingTimeWindowArrayReservoir(long window, TimeUnit windowUnit, Clock clock) {
        Preconditions.checkState((window > 0L ? 1 : 0) != 0, (String)"window must be positive");
        Preconditions.checkNotNull((Object)((Object)windowUnit), (String)"windowUnit");
        Preconditions.checkNotNull((Object)clock, (String)"clock");
        return new SlidingTimeWindowArrayReservoir(window, windowUnit, clock);
    }
}

