/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.palantir.tritium.metrics.InstrumentedSslEngine;
import com.palantir.tritium.metrics.InstrumentedSslServerSocketFactory;
import com.palantir.tritium.metrics.InstrumentedSslSocketFactory;
import com.palantir.tritium.metrics.TlsMetrics;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.jspecify.annotations.Nullable;

final class InstrumentedSslContext
extends SSLContext {
    private final SSLContext context;
    private final String name;

    InstrumentedSslContext(SSLContext context, TlsMetrics metrics, String name) {
        super(new InstrumentedSslContextSpi(context, metrics, name), context.getProvider(), context.getProtocol());
        this.context = context;
        this.name = name;
    }

    public String toString() {
        return "InstrumentedSSLContext{delegate=" + String.valueOf(this.context) + ", name=" + this.name + "}";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InstrumentedSslContext that = (InstrumentedSslContext)other;
        return this.context.equals(that.context) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.name);
    }

    private static final class InstrumentedSslContextSpi
    extends SSLContextSpi {
        private final SSLContext context;
        private final TlsMetrics metrics;
        private final String name;

        InstrumentedSslContextSpi(SSLContext context, TlsMetrics metrics, String name) {
            this.context = context;
            this.metrics = metrics;
            this.name = name;
        }

        @Override
        protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
            this.context.init(keyManagers, trustManagers, secureRandom);
        }

        @Override
        protected SSLSocketFactory engineGetSocketFactory() {
            return new InstrumentedSslSocketFactory(this.context.getSocketFactory(), this.metrics, this.name);
        }

        @Override
        protected SSLServerSocketFactory engineGetServerSocketFactory() {
            return new InstrumentedSslServerSocketFactory(this.context.getServerSocketFactory(), this.metrics, this.name);
        }

        @Override
        protected SSLEngine engineCreateSSLEngine() {
            return InstrumentedSslEngine.instrument(this.context.createSSLEngine(), this.metrics, this.name);
        }

        @Override
        protected SSLEngine engineCreateSSLEngine(String host, int port) {
            return InstrumentedSslEngine.instrument(this.context.createSSLEngine(host, port), this.metrics, this.name);
        }

        @Override
        protected SSLSessionContext engineGetServerSessionContext() {
            return this.context.getServerSessionContext();
        }

        @Override
        protected SSLSessionContext engineGetClientSessionContext() {
            return this.context.getClientSessionContext();
        }

        @Override
        protected SSLParameters engineGetDefaultSSLParameters() {
            return this.context.getDefaultSSLParameters();
        }

        @Override
        protected SSLParameters engineGetSupportedSSLParameters() {
            return this.context.getSupportedSSLParameters();
        }

        public String toString() {
            return "InstrumentedSSLContextSpi{delegate=" + String.valueOf(this.context) + ", name=" + this.name + "}";
        }
    }
}

