/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.event.InstrumentationProperties;
import com.palantir.tritium.metrics.TlsMetrics;

final class HandshakeInstrumentation {
    private static final SafeLogger log = SafeLoggerFactory.get(HandshakeInstrumentation.class);

    static void record(TlsMetrics metrics, String contextName, String cipherSuite, String protocol) {
        metrics.handshake().context(contextName).cipher(cipherSuite).protocol(protocol).build().mark();
        if (log.isDebugEnabled()) {
            log.debug("TLS Handshake completed for context {}, cipher {}, protocol {}", (Arg)SafeArg.of((String)"context", (Object)contextName), (Arg)SafeArg.of((String)"cipherSuite", (Object)cipherSuite), (Arg)SafeArg.of((String)"protocol", (Object)protocol));
        }
    }

    static boolean isSocketInstrumentationEnabled() {
        return log.isDebugEnabled() || InstrumentationProperties.isSpecificEnabled((String)"tls.socket", (boolean)false);
    }

    private HandshakeInstrumentation() {
    }
}

