/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event.metrics;

import com.codahale.metrics.Timer;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.event.AbstractInvocationEventHandler;
import com.palantir.tritium.event.DefaultInvocationContext;
import com.palantir.tritium.event.InstrumentationProperties;
import com.palantir.tritium.event.InvocationContext;
import com.palantir.tritium.event.metrics.InstrumentationMetrics;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TaggedMetricsServiceInvocationEventHandler
extends AbstractInvocationEventHandler<InvocationContext> {
    private final ConcurrentMap<Method, Timer> successTimerCache = new ConcurrentHashMap<Method, Timer>();
    private final ConcurrentMap<Method, Timer> failureTimerCache = new ConcurrentHashMap<Method, Timer>();
    private final Function<Method, Timer> onSuccessTimerMappingFunction;
    private final Function<Method, Timer> onFailureTimerMappingFunction;

    public TaggedMetricsServiceInvocationEventHandler(TaggedMetricRegistry taggedMetricRegistry, @Safe String serviceName) {
        super(TaggedMetricsServiceInvocationEventHandler.getEnabledSupplier(serviceName));
        InstrumentationMetrics metrics = InstrumentationMetrics.of(taggedMetricRegistry);
        this.onSuccessTimerMappingFunction = method -> metrics.invocation().serviceName(serviceName).endpoint(method.getName()).result(InstrumentationMetrics.Invocation_Result.SUCCESS).build();
        this.onFailureTimerMappingFunction = method -> metrics.invocation().serviceName(serviceName).endpoint(method.getName()).result(InstrumentationMetrics.Invocation_Result.FAILURE).build();
    }

    private static BooleanSupplier getEnabledSupplier(@Safe String serviceName) {
        return InstrumentationProperties.getSystemPropertySupplier((String)serviceName);
    }

    public final InvocationContext preInvocation(@NonNull Object instance, @NonNull Method method, @NonNull Object[] args) {
        return DefaultInvocationContext.of((Object)instance, (Method)method, (Object[])args);
    }

    public final void onSuccess(@Nullable InvocationContext context, @Nullable Object _result) {
        this.debugIfNullContext(context);
        if (context != null) {
            long nanos = System.nanoTime() - context.getStartTimeNanos();
            this.getSuccessTimer(context.getMethod()).update(nanos, TimeUnit.NANOSECONDS);
        }
    }

    public final void onFailure(@Nullable InvocationContext context, @NonNull Throwable _cause) {
        this.debugIfNullContext(context);
        if (context != null) {
            long nanos = System.nanoTime() - context.getStartTimeNanos();
            this.getFailureTimer(context.getMethod()).update(nanos, TimeUnit.NANOSECONDS);
        }
    }

    private Timer getSuccessTimer(Method method) {
        return this.successTimerCache.computeIfAbsent(method, this.onSuccessTimerMappingFunction);
    }

    private Timer getFailureTimer(Method method) {
        return this.failureTimerCache.computeIfAbsent(method, this.onFailureTimerMappingFunction);
    }
}

