/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.caffeine;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.caffeine.CaffeineCacheStats;
import java.util.Map;

final class CaffeineCacheMetrics
implements MetricSet {
    private final Cache<?, ?> cache;
    private final String cacheName;

    private CaffeineCacheMetrics(Cache<?, ?> cache, String cacheName) {
        this.cache = (Cache)Preconditions.checkNotNull(cache, (String)"cache");
        this.cacheName = (String)Preconditions.checkNotNull((Object)cacheName, (String)"cacheName");
        Preconditions.checkArgument((!cacheName.trim().isEmpty() ? 1 : 0) != 0, (String)"Cache name cannot be blank or empty");
    }

    static CaffeineCacheMetrics create(Cache<?, ?> cache, String cacheName) {
        return new CaffeineCacheMetrics(cache, cacheName);
    }

    public Map<String, Metric> getMetrics() {
        return ImmutableMap.copyOf(CaffeineCacheStats.createCacheGauges(this.cache, name -> this.cacheName + "." + name));
    }
}

