/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tracing.undertow;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tracing.DetachedSpan;
import com.palantir.tracing.InternalTracers;
import com.palantir.tracing.Observability;
import com.palantir.tracing.TagTranslator;
import com.palantir.tracing.Tracers;
import com.palantir.tracing.api.SpanType;
import com.palantir.tracing.undertow.StatusCodeTagTranslator;
import com.palantir.tracing.undertow.TracingAttachments;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.Optional;

final class UndertowTracing {
    private static final SafeLogger log = SafeLoggerFactory.get(UndertowTracing.class);
    private static final HttpString TRACE_ID = HttpString.tryFromString((String)"X-B3-TraceId");
    private static final HttpString SPAN_ID = HttpString.tryFromString((String)"X-B3-SpanId");
    private static final HttpString IS_SAMPLED = HttpString.tryFromString((String)"X-B3-Sampled");
    private static final HttpString FOR_USER_AGENT = HttpString.tryFromString((String)"For-User-Agent");
    @VisibleForTesting
    static final HttpString FETCH_USER_AGENT = HttpString.tryFromString((String)"Fetch-User-Agent");
    private static final AttachmentKey<TagTranslator<? super HttpServerExchange>> TAG_TRANSLATOR_ATTACHMENT_KEY = AttachmentKey.create(TagTranslator.class);

    static DetachedSpan getOrInitializeRequestTrace(HttpServerExchange exchange, String operationName, TagTranslator<? super HttpServerExchange> translator) {
        DetachedSpan detachedSpan = (DetachedSpan)exchange.getAttachment(TracingAttachments.REQUEST_SPAN);
        if (detachedSpan == null) {
            return UndertowTracing.initializeRequestTrace(exchange, operationName, translator);
        }
        return detachedSpan;
    }

    private static DetachedSpan initializeRequestTrace(HttpServerExchange exchange, String operationName, TagTranslator<? super HttpServerExchange> translator) {
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        String maybeTraceId = requestHeaders.getFirst(TRACE_ID);
        boolean newTraceId = maybeTraceId == null;
        String traceId = newTraceId ? Tracers.randomId() : maybeTraceId;
        Optional<String> forUserAgent = UndertowTracing.getForUserAgent(requestHeaders);
        DetachedSpan detachedSpan = UndertowTracing.detachedSpan(operationName, newTraceId, traceId, forUserAgent, requestHeaders);
        UndertowTracing.setExchangeState(exchange, detachedSpan, traceId, translator);
        return detachedSpan;
    }

    private static void setExchangeState(HttpServerExchange exchange, DetachedSpan detachedSpan, String traceId, TagTranslator<? super HttpServerExchange> translator) {
        exchange.getResponseHeaders().put(TRACE_ID, traceId);
        boolean isSampled = InternalTracers.isSampled((DetachedSpan)detachedSpan);
        exchange.putAttachment(TracingAttachments.IS_SAMPLED, (Object)isSampled);
        Optional requestId = InternalTracers.getRequestId((DetachedSpan)detachedSpan);
        if (requestId.isEmpty()) {
            throw new SafeIllegalStateException("No requestId is set", new Arg[]{SafeArg.of((String)"span", (Object)detachedSpan)});
        }
        exchange.putAttachment(TracingAttachments.REQUEST_ID, (Object)((String)requestId.get()));
        exchange.putAttachment(TracingAttachments.REQUEST_SPAN, (Object)detachedSpan);
        exchange.putAttachment(TAG_TRANSLATOR_ATTACHMENT_KEY, translator);
        exchange.addExchangeCompleteListener((ExchangeCompletionListener)DetachedTraceCompletionListener.INSTANCE);
    }

    private static DetachedSpan detachedSpan(String operationName, boolean newTrace, String traceId, Optional<String> forUserAgent, HeaderMap requestHeaders) {
        return DetachedSpan.start((Observability)UndertowTracing.getObservabilityFromHeader(requestHeaders), (String)traceId, forUserAgent, newTrace ? Optional.empty() : Optional.ofNullable(requestHeaders.getFirst(SPAN_ID)), (String)operationName, (SpanType)SpanType.SERVER_INCOMING);
    }

    private static Observability getObservabilityFromHeader(HeaderMap headers) {
        String header = headers.getFirst(IS_SAMPLED);
        if (Strings.isNullOrEmpty((String)header)) {
            return Observability.UNDECIDED;
        }
        return "1".equals(header) ? Observability.SAMPLE : Observability.DO_NOT_SAMPLE;
    }

    private static Optional<String> getForUserAgent(HeaderMap requestHeaders) {
        String forUserAgent = requestHeaders.getFirst(FOR_USER_AGENT);
        if (forUserAgent != null) {
            return Optional.of(forUserAgent);
        }
        String fetchUserAgent = requestHeaders.getFirst(FETCH_USER_AGENT);
        if (fetchUserAgent != null) {
            return Optional.of(fetchUserAgent);
        }
        return Optional.ofNullable(requestHeaders.getFirst(Headers.USER_AGENT));
    }

    private UndertowTracing() {
    }

    private static enum DetachedTraceCompletionListener implements ExchangeCompletionListener
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                DetachedSpan detachedSpan = (DetachedSpan)exchange.getAttachment(TracingAttachments.REQUEST_SPAN);
                if (detachedSpan != null) {
                    detachedSpan.complete(DetachedTraceCompletionListener.tagTranslator(exchange), (Object)exchange);
                }
            }
            catch (Throwable t) {
                log.error("Failed to complete the request tracing span", t);
            }
            finally {
                nextListener.proceed();
            }
        }

        static TagTranslator<? super HttpServerExchange> tagTranslator(HttpServerExchange exchange) {
            TagTranslator translator = (TagTranslator)exchange.getAttachment(TAG_TRANSLATOR_ATTACHMENT_KEY);
            return translator == null ? StatusCodeTagTranslator.INSTANCE : translator;
        }
    }
}

