/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tracing.undertow;

import com.palantir.logsafe.Preconditions;
import com.palantir.tracing.TagTranslator;
import com.palantir.tracing.undertow.StatusCodeTagTranslator;
import com.palantir.tracing.undertow.UndertowTracing;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public final class TracedRequestHandler
implements HttpHandler {
    private static final String DEFAULT_OPERATION_NAME = "Undertow Request";
    private final HttpHandler delegate;
    private final String operationName;
    private final TagTranslator<? super HttpServerExchange> translator;

    public TracedRequestHandler(HttpHandler delegate, String operationName, TagTranslator<? super HttpServerExchange> translator) {
        this.delegate = (HttpHandler)Preconditions.checkNotNull((Object)delegate, (String)"HttpHandler is required");
        this.operationName = (String)Preconditions.checkNotNull((Object)operationName, (String)"Operation name is required");
        this.translator = (TagTranslator)Preconditions.checkNotNull(translator, (String)"TagTranslator is required");
    }

    public TracedRequestHandler(HttpHandler delegate, TagTranslator<? super HttpServerExchange> translator) {
        this(delegate, DEFAULT_OPERATION_NAME, translator);
    }

    public TracedRequestHandler(HttpHandler delegate) {
        this(delegate, StatusCodeTagTranslator.INSTANCE);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        UndertowTracing.getOrInitializeRequestTrace(exchange, this.operationName, this.translator);
        this.delegate.handleRequest(exchange);
    }

    public String toString() {
        return "TracedRequestHandler{delegate=" + String.valueOf(this.delegate) + ", operationName='" + this.operationName + "'}";
    }
}

