/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tracing.undertow;

import com.palantir.logsafe.Preconditions;
import com.palantir.tracing.CloseableSpan;
import com.palantir.tracing.DetachedSpan;
import com.palantir.tracing.TagTranslator;
import com.palantir.tracing.undertow.NoTagTranslator;
import com.palantir.tracing.undertow.StatusCodeTagTranslator;
import com.palantir.tracing.undertow.TracingAttachments;
import com.palantir.tracing.undertow.UndertowTracing;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;

public final class TracedOperationHandler
implements HttpHandler {
    @Deprecated
    public static final AttachmentKey<Boolean> IS_SAMPLED_ATTACHMENT = TracingAttachments.IS_SAMPLED;
    private final String operation;
    private final TagTranslator<? super HttpServerExchange> translator;
    private final HttpHandler delegate;

    public TracedOperationHandler(HttpHandler delegate, String operation, TagTranslator<? super HttpServerExchange> translator) {
        this.delegate = (HttpHandler)Preconditions.checkNotNull((Object)delegate, (String)"A delegate HttpHandler is required");
        this.operation = (String)Preconditions.checkNotNull((Object)operation, (String)"Operation name is required");
        this.translator = (TagTranslator)Preconditions.checkNotNull(translator, (String)"TagTranslator is required");
    }

    public TracedOperationHandler(HttpHandler delegate, String operation) {
        this(delegate, "Undertow: " + (String)Preconditions.checkNotNull((Object)operation, (String)"Operation name is required"), NoTagTranslator.INSTANCE);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        DetachedSpan detachedSpan = UndertowTracing.getOrInitializeRequestTrace(exchange, "Undertow Request", StatusCodeTagTranslator.INSTANCE);
        try (CloseableSpan ignored = detachedSpan.childSpan(this.operation, this.translator, (Object)exchange);){
            this.delegate.handleRequest(exchange);
        }
    }

    public String toString() {
        return "TracedOperationHandler{operation='" + this.operation + "', delegate=" + String.valueOf(this.delegate) + "}";
    }
}

