/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tracing.undertow;

import com.palantir.tracing.TagTranslator;
import io.undertow.server.HttpServerExchange;

enum StatusCodeTagTranslator implements TagTranslator<HttpServerExchange>
{
    INSTANCE;


    public <T> void translate(TagTranslator.TagAdapter<T> adapter, T target, HttpServerExchange exchange) {
        adapter.tag(target, "http.status_code", StatusCodeTagTranslator.statusString(exchange.getStatusCode()));
    }

    static String statusString(int statusCode) {
        switch (statusCode) {
            case 200: {
                return "200";
            }
            case 204: {
                return "204";
            }
        }
        return Integer.toString(statusCode);
    }
}

