/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;

final class Attachments {
    private final Map<AttachmentKey<?>, Object> attachments = new ConcurrentHashMap(0);

    private Attachments() {
    }

    static Attachments create() {
        return new Attachments();
    }

    <V> @Nullable V put(AttachmentKey<V> key, V value) {
        Preconditions.checkNotNull(key, (String)"key");
        Preconditions.checkNotNull(value, (String)"value");
        key.checkIsInstance(value);
        Object result = this.attachments.put(key, value);
        return (V)result;
    }

    <V> @Nullable V getOrDefault(AttachmentKey<V> key, @Nullable V defaultValue) {
        Preconditions.checkNotNull(key, (String)"key");
        Object result = this.attachments.getOrDefault(key, defaultValue);
        return (V)result;
    }

    static <T> AttachmentKey<T> createAttachmentKey(Class<? super T> valueClazz) {
        Preconditions.checkNotNull(valueClazz, (String)"valueClazz");
        AttachmentKey<? super T> key = new AttachmentKey<T>(valueClazz);
        return key;
    }

    static final class AttachmentKey<V> {
        private final Class<V> valueClazz;

        private AttachmentKey(Class<V> valueClazz) {
            this.valueClazz = valueClazz;
        }

        private void checkIsInstance(V value) {
            if (!this.valueClazz.isInstance(value)) {
                throw new SafeIllegalArgumentException("Unexpected type", new Arg[]{SafeArg.of((String)"expected", this.valueClazz), SafeArg.of((String)"actualType", value == null ? null : value.getClass())});
            }
        }
    }
}

