/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.Config;
import com.palantir.dialogue.core.DialogueTracing;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.tracing.CloseableSpan;
import com.palantir.tracing.DetachedSpan;
import com.palantir.tracing.TagTranslator;
import com.palantir.tracing.Tracer;
import org.jspecify.annotations.Nullable;

final class TracedChannel
implements EndpointChannel {
    private final EndpointChannel delegate;
    private final String operationName;
    private final TagTranslator<Response> responseTranslator;
    private final TagTranslator<Throwable> throwableTranslator;

    private TracedChannel(EndpointChannel delegate, String operationName, ImmutableMap<String, String> tags) {
        this.delegate = delegate;
        this.operationName = operationName;
        this.responseTranslator = DialogueTracing.responseTranslator(tags);
        this.throwableTranslator = DialogueTracing.failureTranslator(tags);
    }

    static EndpointChannel create(Config cf, EndpointChannel delegate, Endpoint endpoint) {
        String operationName = "Dialogue: request " + endpoint.serviceName() + "#" + endpoint.endpointName();
        return new TracedChannel(delegate, operationName, TracedChannel.tracingTags(cf, endpoint));
    }

    private static ImmutableMap<String, String> tracingTags(Config cf, Endpoint endpoint) {
        ImmutableMap<String, String> endpointTags = DialogueTracing.tracingTags(endpoint);
        ImmutableMap<String, String> configTags = DialogueTracing.tracingTags(cf);
        return ImmutableMap.builderWithExpectedSize((int)(endpointTags.size() + configTags.size())).putAll(endpointTags).putAll(configTags).buildOrThrow();
    }

    public ListenableFuture<Response> execute(Request request) {
        if (Tracer.hasUnobservableTrace()) {
            return this.delegate.execute(request);
        }
        return this.executeSampled(request);
    }

    private ListenableFuture<Response> executeSampled(Request request) {
        ListenableFuture listenableFuture;
        block8: {
            final DetachedSpan span = DetachedSpan.start((String)this.operationName);
            CloseableSpan ignored = span.attach();
            try {
                listenableFuture = DialogueFutures.addDirectCallback((ListenableFuture)this.delegate.execute(request), (FutureCallback)new FutureCallback<Response>(){

                    public void onSuccess(@Nullable Response response) {
                        if (response == null) {
                            span.complete();
                        } else {
                            span.complete(TracedChannel.this.responseTranslator, (Object)response);
                        }
                    }

                    public void onFailure(Throwable throwable) {
                        span.complete(TracedChannel.this.throwableTranslator, (Object)throwable);
                    }
                });
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    span.complete(this.throwableTranslator, (Object)t);
                    throw t;
                }
            }
            ignored.close();
        }
        return listenableFuture;
    }

    public String toString() {
        return "TracedChannel{operationName=" + this.operationName + ", delegate=" + String.valueOf(this.delegate) + "}";
    }
}

