/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.DialogueTracing;
import com.palantir.dialogue.core.NeverThrowChannel;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.tracing.CloseableSpan;
import com.palantir.tracing.DetachedSpan;
import com.palantir.tracing.TagTranslator;
import com.palantir.tracing.Tracer;
import com.palantir.tracing.Tracers;
import com.palantir.tracing.TracingHeadersEnrichingFunction;
import com.palantir.tracing.api.SpanType;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class TraceEnrichingChannel
implements Channel {
    private static final String OPERATION = "Dialogue-http-request";
    private final NeverThrowChannel delegate;
    private final TagTranslator<Response> responseTranslator;
    private final TagTranslator<Throwable> throwableTranslator;

    TraceEnrichingChannel(Channel delegate, ImmutableMap<String, String> tags) {
        this.delegate = new NeverThrowChannel(delegate);
        this.responseTranslator = DialogueTracing.responseTranslator(tags);
        this.throwableTranslator = DialogueTracing.failureTranslator(tags);
    }

    public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
        if (Tracer.hasUnobservableTrace()) {
            return this.executeInternal(endpoint, request);
        }
        return this.executeSampled(endpoint, request);
    }

    private ListenableFuture<Response> executeSampled(Endpoint endpoint, Request request) {
        final DetachedSpan span = DetachedSpan.start((String)OPERATION, (SpanType)SpanType.CLIENT_OUTGOING);
        try (CloseableSpan ignored = span.attach();){
            ListenableFuture<Response> future = this.executeInternal(endpoint, request);
            ListenableFuture listenableFuture = DialogueFutures.addDirectCallback(future, (FutureCallback)new FutureCallback<Response>(){

                public void onSuccess(@Nullable Response response) {
                    if (response == null) {
                        span.complete();
                    } else {
                        span.complete(TraceEnrichingChannel.this.responseTranslator, (Object)response);
                    }
                }

                public void onFailure(Throwable throwable) {
                    span.complete(TraceEnrichingChannel.this.throwableTranslator, (Object)throwable);
                }
            });
            return listenableFuture;
        }
    }

    private ListenableFuture<Response> executeInternal(Endpoint endpoint, Request request) {
        Request.Builder requestBuilder = Request.builder().from(request);
        Tracers.addTracingHeaders((Object)requestBuilder, (TracingHeadersEnrichingFunction)RequestTracingHeadersEnrichingFunction.INSTANCE);
        return this.delegate.execute(endpoint, requestBuilder.build());
    }

    public String toString() {
        return "TracedRequestChannel{" + String.valueOf(this.delegate) + "}";
    }

    private static enum RequestTracingHeadersEnrichingFunction implements TracingHeadersEnrichingFunction<Request.Builder>
    {
        INSTANCE;


        public void addHeader(@NonNull String headerName, @NonNull String headerValue, Request.Builder state) {
            state.putHeaderParams(headerName, headerValue);
        }
    }
}

