/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.RateLimiter;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.ClientMetrics;
import com.palantir.dialogue.core.Config;
import com.palantir.dialogue.core.Responses;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

final class TimingEndpointChannel
implements EndpointChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(TimingEndpointChannel.class);
    private static final RateLimiter unknownThrowableLoggingRateLimiter = RateLimiter.create((double)1.0);
    private final EndpointChannel delegate;
    private final Supplier<Timer> successTimer;
    private final Supplier<Timer> failureTimer;
    private final Ticker ticker;

    TimingEndpointChannel(EndpointChannel delegate, Ticker ticker, TaggedMetricRegistry taggedMetrics, String channelName, Endpoint endpoint) {
        this.delegate = delegate;
        this.ticker = ticker;
        ClientMetrics metrics = ClientMetrics.of(taggedMetrics);
        this.successTimer = Suppliers.memoize(() -> metrics.response().channelName(channelName).serviceName(endpoint.serviceName()).endpoint(endpoint.endpointName()).status("success").build());
        this.failureTimer = Suppliers.memoize(() -> metrics.response().channelName(channelName).serviceName(endpoint.serviceName()).endpoint(endpoint.endpointName()).status("failure").build());
    }

    static EndpointChannel create(Config cf, EndpointChannel delegate, Endpoint endpoint) {
        return new TimingEndpointChannel(delegate, cf.ticker(), cf.clientConf().taggedMetricRegistry(), cf.channelName(), endpoint);
    }

    public ListenableFuture<Response> execute(Request request) {
        final long beforeNanos = this.ticker.read();
        ListenableFuture response = this.delegate.execute(request);
        return DialogueFutures.addDirectCallback((ListenableFuture)response, (FutureCallback)new FutureCallback<Response>(){

            public void onSuccess(@Nullable Response response) {
                if (Responses.isSuccess(response)) {
                    this.updateTimer(TimingEndpointChannel.this.successTimer);
                } else if (Responses.isQosStatus(response) || Responses.isInternalServerError(response)) {
                    this.updateTimer(TimingEndpointChannel.this.failureTimer);
                }
            }

            public void onFailure(Throwable throwable) {
                if (throwable instanceof IOException) {
                    this.updateTimer(TimingEndpointChannel.this.failureTimer);
                } else if (unknownThrowableLoggingRateLimiter.tryAcquire()) {
                    log.info("Unknown failure", (Arg)SafeArg.of((String)"exceptionClass", (Object)throwable.getClass().getName()));
                }
            }

            private void updateTimer(Supplier<Timer> timer) {
                timer.get().update(TimingEndpointChannel.this.ticker.read() - beforeNanos, TimeUnit.NANOSECONDS);
            }
        });
    }

    public String toString() {
        return "TimingEndpointChannel{" + String.valueOf(this.delegate) + "}";
    }
}

