/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.github.benmanes.caffeine.cache.Ticker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.EndpointChannelFactory;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.BalancedScoreTracker;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Preconditions;
import com.palantir.random.SafeThreadLocalRandom;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.jspecify.annotations.Nullable;

public final class StickyEndpointChannels
implements Supplier<Channel> {
    private final ImmutableList<? extends EndpointChannelFactory> channels;
    private final BalancedScoreTracker tracker;

    private StickyEndpointChannels(Builder params) {
        this.channels = params.channels;
        this.tracker = new BalancedScoreTracker(params.channels.size(), params.random, params.ticker, (TaggedMetricRegistry)Preconditions.checkNotNull((Object)params.taggedMetrics, (String)"taggedMetricRegistry"), (String)Preconditions.checkNotNull((Object)params.channelName, (String)"channelName"));
    }

    @Override
    public Channel get() {
        return new Sticky(this.channels, this.tracker);
    }

    public String toString() {
        return "StickyEndpointChannels{tracker=" + String.valueOf(this.tracker) + ", channels=" + String.valueOf(this.channels) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ImmutableList<? extends EndpointChannelFactory> channels = ImmutableList.of();
        private @Nullable String channelName;
        private @Nullable TaggedMetricRegistry taggedMetrics;
        private Random random = SafeThreadLocalRandom.get();
        private Ticker ticker = Ticker.systemTicker();

        private Builder() {
        }

        public Builder channels(List<? extends EndpointChannelFactory> chans) {
            this.channels = ImmutableList.copyOf(chans);
            return this;
        }

        public Builder channelName(String value) {
            this.channelName = (String)Preconditions.checkNotNull((Object)value, (String)"channelName");
            return this;
        }

        public Builder taggedMetricRegistry(TaggedMetricRegistry value) {
            this.taggedMetrics = (TaggedMetricRegistry)Preconditions.checkNotNull((Object)value, (String)"taggedMetrics");
            return this;
        }

        @VisibleForTesting
        Builder random(Random value) {
            this.random = value;
            return this;
        }

        @VisibleForTesting
        Builder ticker(Ticker value) {
            this.ticker = value;
            return this;
        }

        public StickyEndpointChannels build() {
            return new StickyEndpointChannels(this);
        }
    }

    @ThreadSafe
    private static final class Sticky
    implements EndpointChannelFactory,
    Channel {
        private final ImmutableList<? extends EndpointChannelFactory> channels;
        private final Supplier<BalancedScoreTracker.ChannelScoreInfo> getSingleBestChannel;

        private Sticky(ImmutableList<? extends EndpointChannelFactory> channels, BalancedScoreTracker tracker) {
            this.channels = channels;
            this.getSingleBestChannel = Suppliers.memoize(tracker::getSingleBestChannelByScore);
        }

        public EndpointChannel endpoint(Endpoint endpoint) {
            BalancedScoreTracker.ChannelScoreInfo channelScoreInfo = this.getSingleBestChannel.get();
            int hostIndex = channelScoreInfo.channelIndex();
            EndpointChannel delegate = ((EndpointChannelFactory)this.channels.get(hostIndex)).endpoint(endpoint);
            return new ScoreTrackingEndpointChannel(delegate, channelScoreInfo);
        }

        @Deprecated
        public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
            return this.endpoint(endpoint).execute(request);
        }

        public String toString() {
            return "Sticky{" + String.valueOf(this.channels) + "}";
        }
    }

    private static final class ScoreTrackingEndpointChannel
    implements EndpointChannel {
        private final EndpointChannel delegate;
        private final BalancedScoreTracker.ChannelScoreInfo tracker;

        ScoreTrackingEndpointChannel(EndpointChannel delegate, BalancedScoreTracker.ChannelScoreInfo tracker) {
            this.delegate = delegate;
            this.tracker = tracker;
        }

        public ListenableFuture<Response> execute(Request request) {
            this.tracker.startRequest();
            ListenableFuture future = this.delegate.execute(request);
            this.tracker.observability().markRequestMade();
            DialogueFutures.addDirectCallback((ListenableFuture)future, (FutureCallback)this.tracker);
            return future;
        }

        public String toString() {
            return "ScoreTrackingEndpointChannel{delegate=" + String.valueOf(this.delegate) + ", tracker=" + String.valueOf(this.tracker) + "}";
        }
    }
}

