/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.RequestBody;
import com.palantir.dialogue.Response;
import com.palantir.logsafe.Preconditions;
import java.util.Optional;
import java.util.function.Consumer;

final class RequestBodyValidationChannel
implements EndpointChannel {
    private static final Consumer<RequestBody> BODY_VALIDATOR = RequestBodyValidationChannel::validate;
    private final EndpointChannel delegate;

    RequestBodyValidationChannel(EndpointChannel delegate) {
        this.delegate = (EndpointChannel)Preconditions.checkNotNull((Object)delegate, (String)"delegate is required");
    }

    public ListenableFuture<Response> execute(Request request) {
        RequestBodyValidationChannel.validate(request);
        return this.delegate.execute(request);
    }

    private static void validate(Request request) {
        Optional body = request.body();
        body.ifPresent(BODY_VALIDATOR);
    }

    private static void validate(RequestBody body) {
        Preconditions.checkNotNull((Object)body.contentType(), (String)"RequestBody.contentType is required");
    }
}

