/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;

final class RangeAcceptsIdentityEncodingChannel
implements EndpointChannel {
    private final EndpointChannel delegate;

    RangeAcceptsIdentityEncodingChannel(EndpointChannel delegate) {
        this.delegate = delegate;
    }

    public ListenableFuture<Response> execute(Request request) {
        Request delegateRequest = RangeAcceptsIdentityEncodingChannel.isRangeRequestWithoutAcceptEncoding(request) ? RangeAcceptsIdentityEncodingChannel.withIdentityEncoding(request) : request;
        return this.delegate.execute(delegateRequest);
    }

    private static boolean isRangeRequestWithoutAcceptEncoding(Request request) {
        ListMultimap requestHeaders = request.headerParams();
        return requestHeaders.containsKey((Object)"Range") && !requestHeaders.containsKey((Object)"Accept-Encoding");
    }

    private static Request withIdentityEncoding(Request request) {
        return Request.builder().from(request).putHeaderParams("Accept-Encoding", "identity").build();
    }
}

