/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;

final class InterruptionChannel
implements EndpointChannel {
    private final EndpointChannel endpointChannel;

    InterruptionChannel(EndpointChannel endpointChannel) {
        this.endpointChannel = endpointChannel;
    }

    public ListenableFuture<Response> execute(Request request) {
        if (Thread.currentThread().isInterrupted()) {
            return Futures.immediateFailedFuture((Throwable)new InterruptedException());
        }
        return this.endpointChannel.execute(request);
    }

    public String toString() {
        return "InterruptionChannel{" + String.valueOf(this.endpointChannel) + "}";
    }
}

