/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.collect.ImmutableMap;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.Config;
import com.palantir.tracing.TagTranslator;
import java.util.Map;

final class DialogueTracing {
    static ImmutableMap<String, String> tracingTags(Endpoint endpoint) {
        return ImmutableMap.of((Object)"endpointService", (Object)endpoint.serviceName(), (Object)"endpointName", (Object)endpoint.endpointName(), (Object)"http.method", (Object)endpoint.httpMethod().toString());
    }

    static ImmutableMap<String, String> tracingTags(Config cf) {
        return ImmutableMap.of((Object)"channel", (Object)cf.channelName());
    }

    static ImmutableMap<String, String> tracingTags(Config cf, int hostIndex) {
        return ImmutableMap.of((Object)"channel", (Object)cf.channelName(), (Object)"hostIndex", (Object)Integer.toString(hostIndex));
    }

    static TagTranslator<Response> responseTranslator(final ImmutableMap<String, String> tags) {
        return new TagTranslator<Response>(){

            public <T> void translate(TagTranslator.TagAdapter<T> sink, T target, Response response) {
                sink.tag(target, (Map)tags);
                int status = response.code();
                sink.tag(target, "outcome", status / 100 == 2 ? "success" : "failure");
                sink.tag(target, "http.status_code", Integer.toString(status));
            }
        };
    }

    static TagTranslator<Throwable> failureTranslator(final ImmutableMap<String, String> tags) {
        return new TagTranslator<Throwable>(){

            public <T> void translate(TagTranslator.TagAdapter<T> sink, T target, Throwable response) {
                sink.tag(target, (Map)tags);
                sink.tag(target, "outcome", "failure");
                sink.tag(target, "cause", response.getClass().getSimpleName());
            }
        };
    }

    private DialogueTracing() {
    }
}

