/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.google.common.base.Splitter;
import com.palantir.conjure.java.client.config.NodeSelectionStrategy;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.List;

enum DialogueNodeSelectionStrategy {
    PIN_UNTIL_ERROR,
    PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE,
    BALANCED,
    UNKNOWN;

    private static final SafeLogger log;
    private static final Splitter SPLITTER;

    static List<DialogueNodeSelectionStrategy> fromHeader(String header) {
        return SPLITTER.splitToStream((CharSequence)header).map(DialogueNodeSelectionStrategy::safeValueOf).toList();
    }

    private static DialogueNodeSelectionStrategy safeValueOf(String string) {
        if ("PIN_UNTIL_ERROR".equalsIgnoreCase(string)) {
            return PIN_UNTIL_ERROR;
        }
        if ("PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE".equalsIgnoreCase(string)) {
            return PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE;
        }
        if ("BALANCED".equalsIgnoreCase(string)) {
            return BALANCED;
        }
        log.info("Received unknown selection strategy {}", (Arg)SafeArg.of((String)"strategy", (Object)string));
        return UNKNOWN;
    }

    static DialogueNodeSelectionStrategy of(NodeSelectionStrategy strategy) {
        return switch (strategy) {
            default -> throw new IncompatibleClassChangeError();
            case NodeSelectionStrategy.PIN_UNTIL_ERROR -> PIN_UNTIL_ERROR;
            case NodeSelectionStrategy.PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE -> PIN_UNTIL_ERROR_WITHOUT_RESHUFFLE;
            case NodeSelectionStrategy.ROUND_ROBIN -> BALANCED;
        };
    }

    static {
        log = SafeLoggerFactory.get(DialogueNodeSelectionStrategy.class);
        SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    }
}

