/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.codahale.metrics.Meter;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.core.ClientMetrics;
import com.palantir.dialogue.core.Config;
import com.palantir.dialogue.core.ImmutableLoggingRateLimiterKey;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.time.Duration;
import java.util.Optional;
import org.immutables.value.Value;

final class DeprecationWarningChannel
implements EndpointChannel {
    private static final SafeLogger log = SafeLoggerFactory.get(DeprecationWarningChannel.class);
    private static final Cache<LoggingRateLimiterKey, Object> loggingRateLimiter = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();
    private static final Object SENTINEL = new Object();
    private final EndpointChannel delegate;
    private final ClientMetrics metrics;
    private final FutureCallback<Response> callback;

    private DeprecationWarningChannel(EndpointChannel delegate, TaggedMetricRegistry metrics, Endpoint endpoint, String channelName) {
        this.delegate = delegate;
        this.metrics = ClientMetrics.of(metrics);
        this.callback = this.createCallback(channelName, endpoint);
    }

    static EndpointChannel create(Config cf, EndpointChannel delegate, Endpoint endpoint) {
        TaggedMetricRegistry metrics = cf.clientConf().taggedMetricRegistry();
        return new DeprecationWarningChannel(delegate, metrics, endpoint, cf.channelName());
    }

    public ListenableFuture<Response> execute(Request request) {
        ListenableFuture future = this.delegate.execute(request);
        DialogueFutures.addDirectCallback((ListenableFuture)future, this.callback);
        return future;
    }

    private FutureCallback<Response> createCallback(String channelName, Endpoint endpoint) {
        Supplier meterSupplier = Suppliers.memoize(() -> this.metrics.deprecations(endpoint.serviceName()));
        return DialogueFutures.onSuccess(arg_0 -> this.lambda$createCallback$1((java.util.function.Supplier)meterSupplier, channelName, endpoint, arg_0));
    }

    private boolean tryAcquire(String channelName, Endpoint endpoint) {
        LoggingRateLimiterKey key = LoggingRateLimiterKey.of(channelName, endpoint.serviceName(), endpoint.endpointName());
        if (loggingRateLimiter.getIfPresent((Object)key) == null) {
            loggingRateLimiter.put((Object)key, SENTINEL);
            return true;
        }
        return false;
    }

    public String toString() {
        return "DeprecationWarningChannel{" + String.valueOf(this.delegate) + "}";
    }

    private /* synthetic */ void lambda$createCallback$1(java.util.function.Supplier meterSupplier, String channelName, Endpoint endpoint, Response response) {
        if (response == null) {
            return;
        }
        Optional maybeHeader = response.getFirstHeader("deprecation");
        if (maybeHeader.isEmpty()) {
            return;
        }
        ((Meter)meterSupplier.get()).mark();
        if (log.isWarnEnabled() && this.tryAcquire(channelName, endpoint)) {
            log.warn("Using a deprecated endpoint when connecting to service", (Arg)SafeArg.of((String)"channelName", (Object)channelName), (Arg)SafeArg.of((String)"serviceName", (Object)endpoint.serviceName()), (Arg)SafeArg.of((String)"endpointHttpMethod", (Object)endpoint.httpMethod()), (Arg)SafeArg.of((String)"endpointName", (Object)endpoint.endpointName()), (Arg)SafeArg.of((String)"endpointClientVersion", (Object)endpoint.version()), (Arg)SafeArg.of((String)"server", (Object)response.getFirstHeader("server").orElse("no server header provided")));
        }
    }

    @Value.Immutable
    static interface LoggingRateLimiterKey {
        @Value.Parameter
        public String channelName();

        @Value.Parameter
        public String serviceName();

        @Value.Parameter
        public String endpointName();

        public static LoggingRateLimiterKey of(String channel, String service, String endpoint) {
            return ImmutableLoggingRateLimiterKey.of(channel, service, endpoint);
        }
    }
}

