/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.core;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class ClientMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "dialogue";
    private static final String LIBRARY_VERSION = "6.8.0";
    private final TaggedMetricRegistry registry;

    private ClientMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static ClientMetrics of(TaggedMetricRegistry registry) {
        return new ClientMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    ResponseBuilderChannelNameStage response() {
        return new ResponseBuilder();
    }

    @CheckReturnValue
    Meter deprecations(@Safe String serviceName) {
        return this.registry.meter(ClientMetrics.deprecationsMetricName(serviceName));
    }

    static MetricName deprecationsMetricName(@Safe String serviceName) {
        return MetricName.builder().safeName("client.deprecations").putSafeTags("service-name", serviceName).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    public String toString() {
        return "ClientMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class ResponseBuilder
    implements ResponseBuilderChannelNameStage,
    ResponseBuilderServiceNameStage,
    ResponseBuilderEndpointStage,
    ResponseBuilderStatusStage,
    ResponseBuildStage {
        private String channelName;
        private String serviceName;
        private String endpoint;
        private String status;

        private ResponseBuilder() {
        }

        @Override
        public ResponseBuilder channelName(@Safe String channelName) {
            Preconditions.checkState((this.channelName == null ? 1 : 0) != 0, (String)"channel-name is already set");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (String)"channel-name is required");
            return this;
        }

        @Override
        public ResponseBuilder serviceName(@Safe String serviceName) {
            Preconditions.checkState((this.serviceName == null ? 1 : 0) != 0, (String)"service-name is already set");
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"service-name is required");
            return this;
        }

        @Override
        public ResponseBuilder endpoint(@Safe String endpoint) {
            Preconditions.checkState((this.endpoint == null ? 1 : 0) != 0, (String)"endpoint is already set");
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (String)"endpoint is required");
            return this;
        }

        @Override
        public ResponseBuilder status(@Safe String status) {
            Preconditions.checkState((this.status == null ? 1 : 0) != 0, (String)"status is already set");
            this.status = (String)Preconditions.checkNotNull((Object)status, (String)"status is required");
            return this;
        }

        @Override
        public Timer build() {
            return ClientMetrics.this.registry.timer(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("client.response").putSafeTags("channel-name", this.channelName).putSafeTags("service-name", this.serviceName).putSafeTags("endpoint", this.endpoint).putSafeTags("status", this.status).putSafeTags("libraryName", ClientMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", ClientMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ResponseBuilderStatusStage {
        @CheckReturnValue
        public ResponseBuildStage status(@Safe String var1);
    }

    static interface ResponseBuilderEndpointStage {
        @CheckReturnValue
        public ResponseBuilderStatusStage endpoint(@Safe String var1);
    }

    static interface ResponseBuilderServiceNameStage {
        @CheckReturnValue
        public ResponseBuilderEndpointStage serviceName(@Safe String var1);
    }

    static interface ResponseBuilderChannelNameStage {
        @CheckReturnValue
        public ResponseBuilderServiceNameStage channelName(@Safe String var1);
    }

    static interface ResponseBuildStage {
        @CheckReturnValue
        public Timer build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

