/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.blocking;

import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.RequestAttachmentKey;
import com.palantir.dialogue.blocking.CallingThreadExecutor;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.jspecify.annotations.Nullable;

final class DefaultCallingThreadExecutor
implements CallingThreadExecutor {
    static final RequestAttachmentKey<CallingThreadExecutor> ATTACHMENT_KEY = RequestAttachmentKey.create(CallingThreadExecutor.class);
    private static final SafeLogger log = SafeLoggerFactory.get(DefaultCallingThreadExecutor.class);
    private static final boolean DO_NOT_INTERRUPT = false;
    private final long threadId = Thread.currentThread().getId();
    private final Queue queue = new Queue();

    DefaultCallingThreadExecutor() {
    }

    @Override
    public void execute(Runnable task) {
        this.queue.submit(task);
    }

    @Override
    public void executeQueue(ListenableFuture<?> await) {
        Preconditions.checkState((Thread.currentThread().getId() == this.threadId ? 1 : 0) != 0, (String)"Executing queue on different thread");
        DialogueFutures.addDirectListener(await, () -> this.queue.submitNotifier(this.queue::poison));
        try {
            Runnable toRun;
            while ((toRun = this.queue.getWork()) != null) {
                try {
                    toRun.run();
                }
                catch (Throwable t) {
                    log.error("Failed to execute runnable {}", (Arg)SafeArg.of((String)"runnable", (Object)toRun), t);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.queue.poison();
            await.cancel(false);
        }
    }

    private static final class Queue {
        private boolean poisoned = false;
        private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();

        private Queue() {
        }

        public synchronized void submit(Runnable task) {
            this.checkNotPoisoned();
            this.addTask(task);
        }

        public synchronized void submitNotifier(Runnable task) {
            if (this.poisoned) {
                return;
            }
            this.addTask(task);
        }

        public synchronized void poison() {
            this.poisoned = true;
        }

        public @Nullable Runnable getWork() throws InterruptedException {
            if (!this.isPoisoned()) {
                return this.queue.take();
            }
            return (Runnable)this.queue.poll();
        }

        private synchronized void checkNotPoisoned() {
            if (this.poisoned) {
                log.info("Submitted task after queue is closed");
                throw new RejectedExecutionException("Queue closed");
            }
        }

        private synchronized boolean isPoisoned() {
            return this.poisoned;
        }

        private synchronized void addTask(Runnable task) {
            this.queue.add(task);
        }
    }
}

