/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.annotations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.palantir.dialogue.RequestBody;
import com.palantir.dialogue.annotations.ContentBody;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.client5.http.entity.mime.MultipartPartBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.jspecify.annotations.Nullable;

public final class MultipartRequestBody
implements RequestBody {
    private static final SafeLogger log = SafeLoggerFactory.get(MultipartRequestBody.class);
    private final HttpEntity httpEntity;
    private final List<Part> parts;

    private MultipartRequestBody(HttpEntity httpEntity, List<Part> parts) {
        this.httpEntity = (HttpEntity)Preconditions.checkNotNull((Object)httpEntity, (String)"httpEntity");
        this.parts = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(parts, (String)"parts")));
    }

    public void writeTo(OutputStream output) throws IOException {
        this.httpEntity.writeTo(output);
    }

    public String contentType() {
        return this.httpEntity.getContentType();
    }

    public boolean repeatable() {
        return this.parts.stream().allMatch(part -> part.contentBody.repeatable());
    }

    public OptionalLong contentLength() {
        long contentLength = this.httpEntity.getContentLength();
        return contentLength != -1L ? OptionalLong.of(contentLength) : OptionalLong.empty();
    }

    public void close() {
        try (Closer closer = Closer.create();){
            this.parts.forEach(part -> closer.register((Closeable)part.contentBody));
        }
        catch (IOException | RuntimeException e) {
            log.warn("Failed to close MultipartRequestBody", (Throwable)e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ContentBodyPartBuilder contentBodyPartBuilder(ContentBody contentBody) {
        return new ContentBodyPartBuilder(contentBody);
    }

    public static FormBodyPartBuilder formBodyPartBuilder(String name, ContentBody contentBody) {
        return new FormBodyPartBuilder(name, contentBody);
    }

    public static final class Builder {
        private final MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        private List<Part> parts = new ArrayList<Part>();

        private Builder() {
        }

        @VisibleForTesting
        Builder boundary(String boundary) {
            this.builder.setBoundary(boundary);
            return this;
        }

        public Builder addPart(Part part) {
            Preconditions.checkNotNull((Object)part, (String)"part");
            this.builder.addPart(part.part);
            this.parts.add(part);
            return this;
        }

        public MultipartRequestBody build() {
            return new MultipartRequestBody(this.builder.build(), this.parts);
        }
    }

    public static final class ContentBodyPartBuilder {
        private final ContentBodyAdapter bodyAdapter;
        private final MultipartPartBuilder builder;

        private ContentBodyPartBuilder(ContentBody contentBody) {
            Preconditions.checkNotNull((Object)contentBody, (String)"contentBody");
            this.bodyAdapter = new ContentBodyAdapter(contentBody);
            this.builder = MultipartPartBuilder.create((org.apache.hc.client5.http.entity.mime.ContentBody)this.bodyAdapter);
        }

        public ContentBodyPartBuilder addHeaderValue(String key, String value) {
            this.builder.addHeader(key, value);
            return this;
        }

        public Part build() {
            return new Part(this.builder.build(), this.bodyAdapter.contentBody);
        }
    }

    public static final class FormBodyPartBuilder {
        private final ContentBodyAdapter bodyAdapter;
        private final org.apache.hc.client5.http.entity.mime.FormBodyPartBuilder builder;

        private FormBodyPartBuilder(String name, ContentBody contentBody) {
            this.bodyAdapter = new ContentBodyAdapter(contentBody);
            this.builder = org.apache.hc.client5.http.entity.mime.FormBodyPartBuilder.create((String)name, (org.apache.hc.client5.http.entity.mime.ContentBody)this.bodyAdapter);
        }

        public FormBodyPartBuilder fileName(String fileName) {
            this.bodyAdapter.setFileName(fileName);
            return this;
        }

        public Part build() {
            return new Part((MultipartPart)this.builder.build(), this.bodyAdapter.contentBody);
        }
    }

    public static final class Part {
        private final MultipartPart part;
        private final ContentBody contentBody;

        private Part(MultipartPart part, ContentBody contentBody) {
            this.part = (MultipartPart)Preconditions.checkNotNull((Object)part, (String)"part");
            this.contentBody = contentBody;
        }
    }

    private static final class ContentBodyAdapter
    extends AbstractContentBody {
        private final ContentBody contentBody;
        private @Nullable String fileName;

        private ContentBodyAdapter(ContentBody contentBody) {
            super((ContentType)Preconditions.checkNotNull((Object)ContentType.parse((CharSequence)contentBody.contentType()), (String)"Invalid content type", (Arg)SafeArg.of((String)"contentType", (Object)contentBody.contentType())));
            this.contentBody = contentBody;
        }

        void setFileName(@Nullable String fileName) {
            this.fileName = fileName;
        }

        public long getContentLength() {
            return this.contentBody.contentLength().orElse(-1L);
        }

        public @Nullable String getFilename() {
            return this.fileName;
        }

        public void writeTo(OutputStream out) throws IOException {
            this.contentBody.writeTo(out);
        }
    }
}

