/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.annotations;

import com.palantir.dialogue.RequestBody;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.UnsafeArg;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

final class FormUrlEncodedRequestBody
implements RequestBody {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private final Map<String, String> map;

    FormUrlEncodedRequestBody(Map<String, String> map) {
        this.map = map;
    }

    public void writeTo(OutputStream output) throws IOException {
        boolean first = true;
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                output.write(38);
            }
            Preconditions.checkArgument((entry.getKey() != null ? 1 : 0) != 0, (String)"key must not be null");
            String key = URLEncoder.encode(entry.getKey(), UTF_8);
            output.write(key.getBytes(StandardCharsets.UTF_8));
            output.write(61);
            Preconditions.checkArgument((entry.getValue() != null ? 1 : 0) != 0, (String)"value must not be null", (Arg)UnsafeArg.of((String)"key", (Object)entry.getKey()));
            String value = URLEncoder.encode(entry.getValue(), UTF_8);
            output.write(value.getBytes(StandardCharsets.UTF_8));
        }
    }

    public String contentType() {
        return "application/x-www-form-urlencoded";
    }

    public boolean repeatable() {
        return true;
    }

    public void close() {
    }

    public String toString() {
        return "FormUrlEncodedRequestBody{map.keySet=" + String.valueOf(this.map.keySet()) + "}";
    }
}

