/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.config.ssl.pkcs1;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;

public final class Pkcs1PrivateKeyReader {
    private static final byte INTEGER = 2;
    private static final byte SEQUENCE = 48;
    private final ByteBuffer derBytes;

    public Pkcs1PrivateKeyReader(byte[] derBytes) {
        this.derBytes = ByteBuffer.wrap(derBytes);
    }

    public RSAPrivateKeySpec readRsaKey() {
        byte tag = this.derBytes.get();
        if (tag != 48) {
            throw new SafeRuntimeException("Expected SEQUENCE byte (0x30) at the beginning of RSA private key", new Arg[0]);
        }
        int length = this.readLength();
        this.derBytes.limit(this.derBytes.position() + length);
        BigInteger version = this.readNumber();
        if (version.intValue() == 1) {
            throw new SafeRuntimeException("Only version 0 (two-prime) RSA keys are supported", new Arg[0]);
        }
        BigInteger modulus = this.readNumber();
        BigInteger publicExponent = this.readNumber();
        BigInteger privateExponent = this.readNumber();
        BigInteger primeP = this.readNumber();
        BigInteger primeQ = this.readNumber();
        BigInteger primeExponentP = this.readNumber();
        BigInteger primeExponentQ = this.readNumber();
        BigInteger crtCoefficient = this.readNumber();
        if (publicExponent.signum() == 0 || primeExponentP.signum() == 0 || primeExponentQ.signum() == 0 || primeP.signum() == 0 || primeQ.signum() == 0 || crtCoefficient.signum() == 0) {
            return new RSAPrivateKeySpec(modulus, privateExponent);
        }
        return new RSAPrivateCrtKeySpec(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
    }

    private BigInteger readNumber() {
        byte tag = this.derBytes.get();
        if (tag != 2) {
            throw new SafeRuntimeException("Expected INTEGER byte (0x02) when reading a number", new Arg[0]);
        }
        int length = this.readLength();
        byte[] numberBytes = new byte[length];
        System.arraycopy(this.derBytes.array(), this.derBytes.position(), numberBytes, 0, length);
        this.derBytes.position(this.derBytes.position() + length);
        return new BigInteger(numberBytes);
    }

    private int readLength() {
        byte lengthByte = this.derBytes.get();
        if (lengthByte == -1) {
            throw new SafeRuntimeException("Unable to decode length from der bytes", new Arg[0]);
        }
        if ((lengthByte & 0x80) == 0) {
            return lengthByte;
        }
        if ((lengthByte & 0x7F) == 0) {
            throw new SafeRuntimeException("Indefinite length encoding is not supported", new Arg[0]);
        }
        int lengthOctets = lengthByte & 0x7F;
        if (lengthOctets > 4) {
            throw new SafeRuntimeException("Values bigger than 4GBs are not supported", new Arg[0]);
        }
        int length = 0;
        for (int i = 0; i < lengthOctets; ++i) {
            length <<= 8;
            length += this.derBytes.get() & 0xFF;
        }
        return length;
    }
}

