/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.config.ssl;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import com.palantir.conjure.java.config.ssl.KeyStores;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class DefaultCas {
    private static final SafeLogger log = SafeLoggerFactory.get(DefaultCas.class);
    private static final String CA_CERTIFICATES_CRT = "ca-certificates.crt";
    private static final Supplier<Map<String, X509Certificate>> TRUSTED_CERTIFICATES = Suppliers.memoize(DefaultCas::getTrustedCertificates);

    static Map<String, X509Certificate> getCertificates() {
        return TRUSTED_CERTIFICATES.get();
    }

    private static Map<String, X509Certificate> getTrustedCertificates() {
        ImmutableMap.Builder certificateMap = ImmutableMap.builder();
        try {
            List caCertificates = KeyStores.readX509Certificates(new ByteArrayInputStream(Resources.toByteArray((URL)Resources.getResource(DefaultCas.class, (String)CA_CERTIFICATES_CRT)))).stream().map(cert -> (X509Certificate)cert).collect(Collectors.toList());
            int index = 0;
            for (X509Certificate cert2 : caCertificates) {
                String certificateCommonName = cert2.getSubjectX500Principal().getName().toLowerCase(Locale.ENGLISH);
                certificateMap.put((Object)(certificateCommonName + index), (Object)cert2);
                log.debug("Adding CA certificate", (Arg)SafeArg.of((String)"certificateIndex", (Object)index), (Arg)SafeArg.of((String)"certificateCount", (Object)caCertificates.size()), (Arg)SafeArg.of((String)"certificateCommonName", (Object)certificateCommonName), (Arg)SafeArg.of((String)"expiry", (Object)cert2.getNotAfter()), (Arg)SafeArg.of((String)"sha256Fingerprint", (Object)Hashing.sha256().hashBytes(cert2.getEncoded()).toString()));
                ++index;
            }
        }
        catch (IOException | CertificateException e) {
            throw new SafeRuntimeException("Could not read file as an X.509 certificate", (Throwable)e, new Arg[0]);
        }
        return certificateMap.buildOrThrow();
    }

    private DefaultCas() {
    }
}

