/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.serialization;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.databind.type.TypeParser;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.LookupCache;
import javax.annotation.Nullable;

final class NonCachingTypeFactory
extends TypeFactory {
    static TypeFactory from(TypeFactory original) {
        if (original instanceof NonCachingTypeFactory) {
            return original;
        }
        if (original == TypeFactory.defaultInstance()) {
            return new NonCachingTypeFactory();
        }
        return original.withCache((LookupCache)NoCacheLookupCache.INSTANCE);
    }

    private NonCachingTypeFactory() {
        super((LookupCache)NoCacheLookupCache.INSTANCE);
    }

    private NonCachingTypeFactory(TypeParser parser, @Nullable TypeModifier[] modifiers, ClassLoader classLoader) {
        super((LookupCache)NoCacheLookupCache.INSTANCE, parser, modifiers, classLoader);
    }

    public NonCachingTypeFactory withModifier(TypeModifier mod) {
        return new NonCachingTypeFactory(this._parser, NonCachingTypeFactory.computeModifiers(this._modifiers, mod), this._classLoader);
    }

    @Nullable
    private static TypeModifier[] computeModifiers(TypeModifier[] existing, TypeModifier newModifier) {
        if (newModifier == null) {
            return null;
        }
        if (existing == null || existing.length == 0) {
            return new TypeModifier[]{newModifier};
        }
        return (TypeModifier[])ArrayBuilders.insertInListNoDup((Object[])existing, (Object)newModifier);
    }

    public NonCachingTypeFactory withClassLoader(ClassLoader classLoader) {
        return new NonCachingTypeFactory(this._parser, this._modifiers, classLoader);
    }

    public NonCachingTypeFactory withCache(LRUMap<Object, JavaType> _cache) {
        return this;
    }

    public NonCachingTypeFactory withCache(LookupCache<Object, JavaType> _cache) {
        return this;
    }

    private static enum NoCacheLookupCache implements LookupCache<Object, JavaType>
    {
        INSTANCE;


        public int size() {
            return 0;
        }

        @Nullable
        public JavaType get(Object _key) {
            return null;
        }

        @Nullable
        public JavaType put(Object _key, JavaType _value) {
            return null;
        }

        public JavaType putIfAbsent(Object _key, JavaType _value) {
            return null;
        }

        public void clear() {
        }

        public String toString() {
            return "NoCacheLookupCache{}";
        }
    }
}

