/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.serialization;

import com.codahale.metrics.Histogram;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class JsonParserMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "conjure-java-runtime";
    private static final String LIBRARY_VERSION = "8.24.0";
    private final TaggedMetricRegistry registry;

    private JsonParserMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static JsonParserMetrics of(TaggedMetricRegistry registry) {
        return new JsonParserMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    Histogram stringLength(@Safe String format) {
        return this.registry.histogram(JsonParserMetrics.stringLengthMetricName(format));
    }

    static MetricName stringLengthMetricName(@Safe String format) {
        return MetricName.builder().safeName("json.parser.string.length").putSafeTags("format", format).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    public String toString() {
        return "JsonParserMetrics{registry=" + String.valueOf(this.registry) + "}";
    }
}

