/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.client.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class CipherSuites {
    private static final ImmutableList<String> CIPHERS = ImmutableList.of((Object)"TLS_AES_256_GCM_SHA384", (Object)"TLS_AES_128_GCM_SHA256", (Object)"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", (Object)"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", (Object)"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", (Object)"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", (Object)"TLS_CHACHA20_POLY1305_SHA256", (Object)"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", (Object)"TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
    private static final ImmutableSet<String> DEPRECATED_CIPHERS = ImmutableSet.of((Object)"TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", (Object)"TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", (Object)"TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", (Object)"TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", (Object)"TLS_RSA_WITH_AES_256_GCM_SHA384", (Object)"TLS_RSA_WITH_AES_128_GCM_SHA256", (Object[])new String[]{"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256"});
    private static final ImmutableList<String> ALL_CIPHER_SUITES = ImmutableList.builder().addAll(CIPHERS).addAll(DEPRECATED_CIPHERS).build();

    @Deprecated
    public static String[] fastCipherSuites() {
        return CipherSuites.allCipherSuites();
    }

    @Deprecated
    public static String[] gcmCipherSuites() {
        return (String[])ALL_CIPHER_SUITES.stream().filter(cipherString -> cipherString.contains("_GCM_")).toArray(String[]::new);
    }

    public static String[] allCipherSuites() {
        return (String[])ALL_CIPHER_SUITES.toArray((Object[])new String[0]);
    }

    public static Set<String> deprecatedCiphers() {
        return DEPRECATED_CIPHERS;
    }

    private CipherSuites() {
    }
}

