/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.lib;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public abstract class TypeMarker<T> {
    private final Type type;

    protected TypeMarker() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        Preconditions.checkArgument((boolean)(genericSuperclass instanceof ParameterizedType), (String)"Class is not parameterized", (Arg)SafeArg.of((String)"class", (Object)genericSuperclass));
        this.type = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
        Preconditions.checkArgument((!(this.type instanceof TypeVariable) ? 1 : 0) != 0, (String)"TypeMarker does not support variable types", (Arg)SafeArg.of((String)"typeVariable", (Object)this.type));
    }

    private TypeMarker(Type type) {
        this.type = (Type)Preconditions.checkNotNull((Object)type, (String)"Type is required");
    }

    public final Type getType() {
        return this.type;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TypeMarker) {
            TypeMarker that = (TypeMarker)other;
            return this.type.equals(that.type);
        }
        return false;
    }

    public final int hashCode() {
        return this.type.hashCode();
    }

    public final String toString() {
        return "TypeMarker{type=" + String.valueOf(this.type) + "}";
    }

    public static TypeMarker<?> of(Type type) {
        return new WrappingTypeMarker(type);
    }

    private static final class WrappingTypeMarker
    extends TypeMarker<Object> {
        private WrappingTypeMarker(Type type) {
            super(type);
        }
    }
}

