/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.lib;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.logsafe.Preconditions;
import io.undertow.server.HttpHandler;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public interface Endpoint {
    public HttpString method();

    public String template();

    public HttpHandler handler();

    public String serviceName();

    public String name();

    default public Optional<String> deprecated() {
        return Optional.empty();
    }

    default public Set<String> tags() {
        return Collections.emptySet();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpString method;
        private String template;
        private HttpHandler handler;
        private String serviceName;
        private String name;
        private Optional<String> deprecated = Optional.empty();
        private ImmutableSet<String> tags = ImmutableSet.of();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder method(HttpString value) {
            this.method = (HttpString)Preconditions.checkNotNull((Object)value, (String)"method is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder template(String value) {
            this.template = (String)Preconditions.checkNotNull((Object)value, (String)"template is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder handler(HttpHandler value) {
            this.handler = (HttpHandler)Preconditions.checkNotNull((Object)value, (String)"handler is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder serviceName(String value) {
            this.serviceName = (String)Preconditions.checkNotNull((Object)value, (String)"serviceName is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name = (String)Preconditions.checkNotNull((Object)value, (String)"name is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder deprecated(Optional<String> value) {
            this.deprecated = (Optional)Preconditions.checkNotNull(value, (String)"deprecated is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tags(Iterable<String> value) {
            this.tags = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(value, (String)"tags are required")));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder from(Endpoint endpoint) {
            this.method = endpoint.method();
            this.template = endpoint.template();
            this.handler = endpoint.handler();
            this.serviceName = endpoint.serviceName();
            this.name = endpoint.name();
            this.deprecated = endpoint.deprecated();
            this.tags = ImmutableSet.copyOf(endpoint.tags());
            return this;
        }

        public Endpoint build() {
            Preconditions.checkNotNull((Object)this.method, (String)"method is required");
            Preconditions.checkNotNull((Object)this.template, (String)"template is required");
            Preconditions.checkNotNull((Object)this.handler, (String)"handler is required");
            Preconditions.checkNotNull((Object)this.serviceName, (String)"serviceName is required");
            Preconditions.checkNotNull((Object)this.name, (String)"name is required");
            return new Endpoint(){

                @Override
                public HttpString method() {
                    return method;
                }

                @Override
                public String template() {
                    return template;
                }

                @Override
                public HttpHandler handler() {
                    return handler;
                }

                @Override
                public String serviceName() {
                    return serviceName;
                }

                @Override
                public String name() {
                    return name;
                }

                @Override
                public Optional<String> deprecated() {
                    return deprecated;
                }

                @Override
                public Set<String> tags() {
                    return tags;
                }
            };
        }
    }
}

