/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.annotations;

import com.google.common.base.Splitter;
import com.palantir.conjure.java.undertow.annotations.CollectionParamDecoder;
import com.palantir.conjure.java.undertow.lib.Deserializer;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathTemplateMatch;
import io.undertow.util.URLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class PathMultiParamDeserializer<T>
implements Deserializer<T> {
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');
    private final String pathParameterName;
    private final CollectionParamDecoder<? extends T> decoder;

    public PathMultiParamDeserializer(String pathParameterName, CollectionParamDecoder<? extends T> decoder) {
        this.pathParameterName = (String)Preconditions.checkNotNull((Object)pathParameterName, (String)"Path parameter name is required");
        this.decoder = (CollectionParamDecoder)Preconditions.checkNotNull(decoder, (String)"Decoder is required");
    }

    public T deserialize(HttpServerExchange exchange) {
        Map pathParams = ((PathTemplateMatch)exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY)).getParameters();
        String value = (String)pathParams.get(this.pathParameterName);
        if (value == null) {
            throw new SafeIllegalStateException("Failed to find path parameter", new Arg[]{SafeArg.of((String)"pathParameter", (Object)this.pathParameterName)});
        }
        List<String> values = this.parseRawValue(exchange, value);
        return (T)Preconditions.checkNotNull(this.decoder.decode(values), (String)"Decoder produced a null value");
    }

    private List<String> parseRawValue(HttpServerExchange exchange, String pathParameterValue) {
        boolean shouldDecode = !exchange.getConnection().getUndertowOptions().get(UndertowOptions.DECODE_URL, true);
        List values = SLASH_SPLITTER.splitToList((CharSequence)pathParameterValue);
        if (shouldDecode) {
            StringBuilder buf = new StringBuilder(pathParameterValue.length());
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (int i = 0; i < values.size(); ++i) {
                result.add(URLUtils.decode((String)((String)values.get(i)), (String)"UTF-8", (boolean)true, (boolean)false, (StringBuilder)buf));
            }
            return Collections.unmodifiableList(result);
        }
        return values;
    }
}

