/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.annotations;

import com.palantir.conjure.java.undertow.annotations.CollectionParamDecoder;
import com.palantir.conjure.java.undertow.lib.Deserializer;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.Collections;

public final class HeaderParamDeserializer<T>
implements Deserializer<T> {
    private final HttpString headerName;
    private final CollectionParamDecoder<? extends T> decoder;

    public HeaderParamDeserializer(String headerName, CollectionParamDecoder<? extends T> decoder) {
        Preconditions.checkNotNull((Object)headerName, (String)"Header name is required");
        this.headerName = (HttpString)Preconditions.checkNotNull((Object)HttpString.tryFromString((String)headerName), (String)"Failed to parse header", (Arg)SafeArg.of((String)"headerName", (Object)headerName));
        this.decoder = (CollectionParamDecoder)Preconditions.checkNotNull(decoder, (String)"Decoder is required");
    }

    public T deserialize(HttpServerExchange exchange) {
        HeaderValues maybeValues = exchange.getRequestHeaders().get(this.headerName);
        return (T)Preconditions.checkNotNull(this.decoder.decode(maybeValues == null ? Collections.emptyList() : Collections.unmodifiableCollection(maybeValues)), (String)"Decoder produced a null value");
    }

    public String toString() {
        return "HeaderParamDeserializer{headerName=" + String.valueOf(this.headerName) + ", decoder=" + String.valueOf(this.decoder) + "}";
    }
}

