/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.annotations;

import com.palantir.conjure.java.undertow.lib.Deserializer;
import com.palantir.conjure.java.undertow.lib.UndertowRuntime;
import com.palantir.logsafe.Preconditions;
import com.palantir.tokens.auth.BearerToken;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;

public final class BearerTokenCookieDeserializer
implements Deserializer<BearerToken> {
    private final UndertowRuntime runtime;
    private final String cookieName;

    public BearerTokenCookieDeserializer(UndertowRuntime runtime, String cookieName) {
        this.runtime = (UndertowRuntime)Preconditions.checkNotNull((Object)runtime, (String)"Undertow runtime is required");
        this.cookieName = (String)Preconditions.checkNotNull((Object)cookieName, (String)"Cookie name is required");
    }

    public BearerToken deserialize(HttpServerExchange exchange) throws IOException {
        return this.runtime.auth().cookie(exchange, this.cookieName);
    }

    public String toString() {
        return "BearerTokenCookieDeserializer{runtime=" + String.valueOf(this.runtime) + ", cookieName='" + this.cookieName + "'}";
    }
}

