/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.lib;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.logsafe.Preconditions;

public final class SafeLong
implements Comparable<SafeLong> {
    private static final long MIN_SAFE_VALUE = -9007199254740991L;
    private static final long MAX_SAFE_VALUE = 0x1FFFFFFFFFFFFFL;
    public static final SafeLong MAX_VALUE = SafeLong.of(0x1FFFFFFFFFFFFFL);
    public static final SafeLong MIN_VALUE = SafeLong.of(-9007199254740991L);
    private final long longValue;

    private SafeLong(long longValue) {
        this.longValue = SafeLong.check(longValue);
    }

    @JsonValue
    public long longValue() {
        return this.longValue;
    }

    private static long check(long value) {
        Preconditions.checkArgument((-9007199254740991L <= value && value <= 0x1FFFFFFFFFFFFFL ? 1 : 0) != 0, (String)"number must be safely representable in javascript i.e. lie between -9007199254740991 and 9007199254740991");
        return value;
    }

    public static SafeLong valueOf(String value) {
        return SafeLong.of(Long.parseLong(value));
    }

    @JsonCreator
    public static SafeLong of(long value) {
        return new SafeLong(value);
    }

    public String toString() {
        return Long.toString(this.longValue);
    }

    @Override
    public int compareTo(SafeLong other) {
        return Long.compare(this.longValue, other.longValue);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SafeLong safeLong = (SafeLong)other;
        return this.longValue == safeLong.longValue;
    }

    public int hashCode() {
        return 177573 + Long.hashCode(this.longValue);
    }
}

